
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for plotting
gdp_growth_rate = np.array([-2, 0, 1, 2, 3, 4])  # in percentage
unemployment_rate = np.array([8, 7, 6, 5, 4, 3])  # in percentage

# Labels and Plot Types
x_critical_growth_1 = -2
label_critical_growth_1 = "Critical Growth -2%"
x_critical_growth_2 = 3
label_critical_growth_2 = "Critical Growth 3%"
label_economic_trend = "Economic Trend"

# Axes Limits and Labels
yticks_values = np.arange(3, 9, 1)
ylim_values = [3, 9]
xlabel_value = "GDP Growth Rate (%)"
ylabel_value = "Unemployment Rate (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(6, 4))

# Add vertical lines for critical growth rates
ax.axvline(
    x=x_critical_growth_1,
    color="#FF8C00",    # Dark Orange
    linestyle="--",
    label=label_critical_growth_1,
    linewidth=2,
)
ax.axvline(
    x=x_critical_growth_2,
    color="#FFD700",    # Gold
    linestyle="--",
    label=label_critical_growth_2,
    linewidth=2,
)

# Plot the economic trend line
ax.plot(
    gdp_growth_rate,
    unemployment_rate,
    label=label_economic_trend,
    color="#228B22",    # Forest Green
    marker="o",
    markersize=8,
    mec="white",
    linewidth=2,
)

# Set yticks
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  # Adjust y-axis limit

# Customize the plot
ax.set_xscale("linear")
ax.set_xlabel(xlabel_value, fontsize=16)
ax.set_ylabel(ylabel_value, fontsize=16)

# Add grid for major ticks only
ax.grid(True, which="major", linestyle="-", linewidth=0.5)

# Add legend
ax.legend(loc="upper right", fontsize=13)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Adjust layout to not cut off legend
plt.savefig("line_173.pdf", bbox_inches="tight")
