
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(42)

# New Data for plotting in Tourism Visit Analysis domain
marketing_spend = np.array([10, 20, 30, 40, 50, 60, 70, 80, 90, 100])
number_of_tourists = np.array([15, 25, 35, 45, 60, 70, 85, 90, 100, 120])

# Labels and Plot Types
x_first_campaign = 30
label_first_campaign = "Initial Campaign"
x_major_campaign = 70
label_major_campaign = "Major Campaign Boost"
label_tourist_trend = "Tourist Arrival Trend"

# Axes Limits and Labels
yticks_values = np.arange(0, 130, 10)
ylim_values = [0, 130]
xlabel_value = "Marketing Spend (in $1000)"
ylabel_value = "Number of Tourists (in 1000s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Add vertical lines for significant campaigns
ax.axvline(
    x=x_first_campaign,
    color="#e41a1c",
    linestyle="--",
    label=label_first_campaign,
    linewidth=2.5,
)
ax.axvline(
    x=x_major_campaign,
    color="#377eb8",
    linestyle="--",
    label=label_major_campaign,
    linewidth=2.5,
)

# Plot the tourist trend line
ax.plot(
    marketing_spend,
    number_of_tourists,
    label=label_tourist_trend,
    color="#4daf4a",
    marker="D",
    markersize=7,
    mec="black",
    linewidth=2.5,
)

# Set yticks
plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)  # Adjust y-axis limit

# Customize the plot
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title("Tourism Visit Analysis", fontsize=16, pad=20)

# Add grid for major ticks only
ax.grid(True, which="major", linestyle="-", linewidth=0.5, alpha=0.7)

# Add legend
ax.legend(loc="upper left", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Adjust layout to not cut off legend
plt.savefig("line_175.pdf", bbox_inches="tight")
