

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data
months = np.array(range(1, 11))
group_a_scores = np.array([60, 65, 70, 75, 80, 85, 90, 85, 90, 95])
group_b_scores = np.array([55, 60, 58, 62, 65, 63, 68, 72, 75, 78])
group_a_std = np.array([2, 2.5, 3, 3.5, 3, 3.5, 3.8, 4, 4.2, 4.5])
group_b_std = np.array([1.5, 2, 2.2, 2.5, 2.8, 3, 3.2, 3.5, 3.7, 4])

# Axes Limits and Labels
xlabel_value = "Months"
xlim_values = [0.5, 10.5]
xticks_values = np.arange(1, 11, 1)

ylabel_value = "Test Scores"
yticks_values_1 = np.arange(50, 101, 10)
ylim_values_1 = [50, 100]
yticks_values_2 = np.arange(50, 101, 10)
ylim_values_2 = [50, 100]
yticks_values_3 = np.arange(50, 101, 10)
ylim_values_3 = [50, 100]

# Labels
labels = ["Group A", "Group B"]

# Titles
titles = ["Test Scores for Group A", "Test Scores for Group B", "Combined Test Scores Trends"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot settings
fig, axs = plt.subplots(1, 3, figsize=(15, 5))
colors = ["#1f77b4", "#2ca02c"]  # Custom colors
markers = ["o", "^"]  # Different markers

for i, ax in enumerate(axs):
    if i == 0:  # Group A
        ax.plot(
            months, group_a_scores, label=labels[0], color=colors[0], marker=markers[0]
        )
        ax.fill_between(
            months,
            group_a_scores - group_a_std,
            group_a_scores + group_a_std,
            color=colors[0],
            alpha=0.2,
        )
    elif i == 1:  # Group B
        ax.plot(
            months, group_b_scores, label=labels[1], color=colors[1], marker=markers[1]
        )
        ax.fill_between(
            months,
            group_b_scores - group_b_std,
            group_b_scores + group_b_std,
            color=colors[1],
            alpha=0.2,
        )
    else:  # Combined
        ax.plot(
            months, group_a_scores, label=labels[0], color=colors[0], marker=markers[0]
        )
        ax.fill_between(
            months,
            group_a_scores - group_a_std,
            group_a_scores + group_a_std,
            color=colors[0],
            alpha=0.2,
        )
        ax.plot(
            months, group_b_scores, label=labels[1], color=colors[1], marker=markers[1]
        )
        ax.fill_between(
            months,
            group_b_scores - group_b_std,
            group_b_scores + group_b_std,
            color=colors[1],
            alpha=0.2,
        )
    ax.set_xticks(xticks_values)
    ax.set_xlim(xlim_values)
    ax.set_title(titles[i])
    ax.set_xlabel(xlabel_value)
    ax.grid(True)

# Adjust subplot layout
plt.subplots_adjust(wspace=0.3)

axs[0].set_yticks(yticks_values_1)
axs[0].set_ylim(ylim_values_1)
axs[1].set_yticks(yticks_values_2)
axs[1].set_ylim(ylim_values_2)
axs[2].set_yticks(yticks_values_3)
axs[2].set_ylim(ylim_values_3)

# Move legend inside the plot area
axs[0].legend(loc="upper left")
axs[1].legend(loc="upper left")
axs[2].legend(loc="upper left")

# Adjust y-axis label to match reference picture
axs[0].set_ylabel(ylabel_value)
axs[1].set_ylabel(ylabel_value)
axs[2].set_ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_177.pdf", bbox_inches="tight")

