

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for each subplot
years = [2015, 2016, 2017, 2018, 2019]
occupancy_rate = [60, 62, 65, 63, 68]  # Hotel Occupancy Rate (%)
adr = [120, 125, 130, 128, 135]  # Average Daily Rate (USD)
revpar = [72, 77.5, 84.5, 80.6, 91.8]  # Revenue Per Available Room (USD)
customer_satisfaction = [75, 78, 80, 79, 83]  # Customer Satisfaction Score (/100)

# Axes Limits and Labels
xlim_values = [2014, 2020]
xticks_values = years

ylabel_value = "Value"
ylim_values_occupancy = [50, 80]
yticks_values_occupancy = np.arange(50, 81, 5)
ylim_values_adr = [110, 140]
yticks_values_adr = np.arange(110, 141, 5)
ylim_values_revpar = [60, 100]
yticks_values_revpar = np.arange(60, 101, 10)
ylim_values_satisfaction = [70, 90]
yticks_values_satisfaction = np.arange(70, 91, 5)

# Labels
label_occupancy = "Hotel Occupancy Rate"
label_adr = "Average Daily Rate"
label_revpar = "RevPAR"
label_satisfaction = "Customer Satisfaction Score"

# Titles
title_occupancy = "Hotel Occupancy Over Years"
title_adr = "Average Daily Rate Over Years"
title_revpar = "RevPAR Over Years"
title_satisfaction = "Customer Satisfaction Over Years"

# Datasets
datasets = ["Hotel Occupancy", "Average Daily Rate", "RevPAR", "Customer Satisfaction"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 4, figsize=(20, 5))

# Plot data on each subplot
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]  # New Color Scheme

axs[0].plot(years, occupancy_rate, "o--", label=label_occupancy, color=colors[0], markersize=10, linewidth=2)
axs[0].set_xticks(xticks_values)
axs[0].set_title(datasets[0], fontsize=14)
axs[0].set_ylabel(ylabel_value, fontsize=14)
axs[0].set_yticks(yticks_values_occupancy)
axs[0].set_ylim(ylim_values_occupancy)

axs[1].plot(years, adr, "^--", label=label_adr, color=colors[1], markersize=10, linewidth=2)
axs[1].set_xticks(xticks_values)
axs[1].set_title(datasets[1], fontsize=14)
axs[1].set_ylabel(ylabel_value, fontsize=14)
axs[1].set_yticks(yticks_values_adr)
axs[1].set_ylim(ylim_values_adr)

axs[2].plot(years, revpar, "s--", label=label_revpar, color=colors[2], markersize=10, linewidth=2)
axs[2].set_xticks(xticks_values)
axs[2].set_title(datasets[2], fontsize=14)
axs[2].set_ylabel(ylabel_value, fontsize=14)
axs[2].set_yticks(yticks_values_revpar)
axs[2].set_ylim(ylim_values_revpar)

axs[3].plot(years, customer_satisfaction, "*--", label=label_satisfaction, color=colors[3], markersize=10, linewidth=2)
axs[3].set_xticks(xticks_values)
axs[3].set_title(datasets[3], fontsize=14)
axs[3].set_ylabel(ylabel_value, fontsize=14)
axs[3].set_yticks(yticks_values_satisfaction)
axs[3].set_ylim(ylim_values_satisfaction)

plt.legend(loc="center", bbox_to_anchor=(-1.6, -0.2), ncol=4, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_185.pdf", bbox_inches="tight")

