

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for each subplot
years = list(range(2010, 2021))
adoption_smartphones = [20, 35, 45, 55, 65, 75, 80, 85, 88, 90, 92]
adoption_internet = [50, 55, 60, 65, 70, 75, 80, 83, 85, 87, 90]
adoption_social_media = [15, 25, 35, 45, 55, 65, 70, 75, 78, 80, 85]
adoption_cloud_services = [10, 20, 30, 40, 50, 60, 65, 70, 73, 75, 78]

adoption_smartphones_2 = [18, 32, 42, 52, 62, 72, 78, 83, 86, 88, 90]
adoption_internet_2 = [48, 53, 58, 63, 68, 73, 78, 81, 83, 85, 88]
adoption_social_media_2 = [13, 23, 33, 43, 53, 63, 68, 73, 76, 78, 82]
adoption_cloud_services_2 = [8, 18, 28, 38, 48, 58, 63, 68, 71, 73, 76]

adoption_smartphones_3 = [15, 30, 40, 50, 60, 70, 77, 82, 85, 87, 89]
adoption_internet_3 = [45, 50, 55, 60, 65, 70, 75, 78, 80, 83, 86]
adoption_social_media_3 = [10, 20, 30, 40, 50, 60, 65, 70, 73, 75, 80]
adoption_cloud_services_3 = [5, 15, 25, 35, 45, 55, 60, 65, 69, 71, 74]

adoption_smartphones_4 = [17, 33, 43, 53, 63, 73, 79, 84, 87, 89, 91]
adoption_internet_4 = [47, 52, 57, 62, 67, 72, 77, 80, 82, 84, 87]
adoption_social_media_4 = [12, 22, 32, 42, 52, 62, 67, 72, 75, 77, 81]
adoption_cloud_services_4 = [7, 17, 27, 37, 47, 57, 62, 67, 70, 72, 75]

# Axes Limits and Labels
xlim_values = [2009, 2021]
xticks_values = years

ylabel_value = "Adoption Rate (%)"
ylim_values_1 = [0, 100]
yticks_values_1 = np.arange(0, 101, 10)
ylim_values_2 = [0, 105]
yticks_values_2 = np.arange(0, 106, 10)

# Labels
label_1 = "Smartphones"
label_2 = "Internet"
label_3 = "Social Media"
label_4 = "Cloud Services"

# Titles
title_1 = "Technology Adoption Rates Over Time"
title_2 = "Comparison of Adoption Rates Across Technologies"

# Plot data on each subplot
categories = ["2010-2020", "2009-2020"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 4, figsize=(20, 5))

# Plot data on each subplot
colors = ["#2a9d8f", "#e76f51", "#264653", "#f4a261"]
markers = ["o", "^", "s", "*"]

# Smartphones
axs[0].plot(years, adoption_smartphones, markers[0]+"--", label=label_1, color=colors[0], markersize=10, linewidth=2)
axs[0].plot(years, adoption_internet, markers[1]+"--", label=label_2, color=colors[1], markersize=10, linewidth=2)
axs[0].plot(years, adoption_social_media, markers[2]+"--", label=label_3, color=colors[2], markersize=10, linewidth=2)
axs[0].plot(years, adoption_cloud_services, markers[3]+"--", label=label_4, color=colors[3], markersize=10, linewidth=2)
axs[0].set_xticks(xticks_values)
axs[0].set_xticklabels(xticks_values,fontsize=6)
axs[0].set_title(categories[0], fontsize=14)
axs[0].set_ylabel(ylabel_value, fontsize=14)
axs[0].set_yticks(yticks_values_1)
axs[0].set_ylim(ylim_values_1)

# Internet
axs[1].plot(years, adoption_smartphones_2, markers[0] + "--", label=label_1, color=colors[0], markersize=10, linewidth=2)
axs[1].plot(years, adoption_internet_2, markers[1] + "--", label=label_2, color=colors[1], markersize=10, linewidth=2)
axs[1].plot(years, adoption_social_media_2, markers[2] + "--", label=label_3, color=colors[2], markersize=10, linewidth=2)
axs[1].plot(years, adoption_cloud_services_2, markers[3] + "--", label=label_4, color=colors[3], markersize=10, linewidth=2)
axs[1].set_xticks(xticks_values)
axs[1].set_xticklabels(xticks_values,fontsize=6)
axs[1].set_title(categories[1], fontsize=14)
axs[1].set_ylabel(ylabel_value, fontsize=14)
axs[1].set_yticks(yticks_values_2)
axs[1].set_ylim(ylim_values_2)


# Social Media
axs[2].plot(years, adoption_smartphones_3, markers[0] + "--", label=label_1, color=colors[0], markersize=10, linewidth=2)
axs[2].plot(years, adoption_internet_3, markers[1] + "--", label=label_2, color=colors[1], markersize=10, linewidth=2)
axs[2].plot(years, adoption_social_media_3, markers[2] + "--", label=label_3, color=colors[2], markersize=10, linewidth=2)
axs[2].plot(years, adoption_cloud_services_3, markers[3] + "--", label=label_4, color=colors[3], markersize=10, linewidth=2)
axs[2].set_xticks(xticks_values)
axs[2].set_xticklabels(xticks_values,fontsize=6)
axs[2].set_title("Social Media", fontsize=14)
axs[2].set_ylabel(ylabel_value, fontsize=14)
axs[2].set_yticks(yticks_values_1)
axs[2].set_ylim(ylim_values_1)

# Cloud Services
axs[3].plot(years, adoption_smartphones_4, markers[0] + "--", label=label_1, color=colors[0], markersize=10, linewidth=2)
axs[3].plot(years, adoption_internet_4, markers[1] + "--", label=label_2, color=colors[1], markersize=10, linewidth=2)
axs[3].plot(years, adoption_social_media_4, markers[2] + "--", label=label_3, color=colors[2], markersize=10, linewidth=2)
axs[3].plot(years, adoption_cloud_services_4, markers[3] + "--", label=label_4, color=colors[3], markersize=10, linewidth=2)
axs[3].set_xticks(xticks_values)
axs[3].set_xticklabels(xticks_values,fontsize=6)
axs[3].set_title("Cloud Services", fontsize=14)
axs[3].set_ylabel(ylabel_value, fontsize=14)
axs[3].set_yticks(yticks_values_2)
axs[3].set_ylim(ylim_values_2)


plt.legend(loc="center", bbox_to_anchor=(-1.6, -0.2), ncol=4, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_186.pdf", bbox_inches="tight")

