
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulated data for energy production
years = np.array(["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"])
solar_production = np.array([10, 20, 35, 50, 70, 95, 120, 150])
solar_err = np.array([2, 3, 5, 7, 6, 8, 10, 12])
wind_production = np.array([15, 25, 30, 55, 60, 80, 105, 130])
wind_err = np.array([3, 4, 5, 6, 8, 9, 11, 15])
coal_production = np.array([200, 190, 180, 170, 160, 150, 140, 130])
coal_err = np.array([5, 10, 10, 10, 10, 10, 10, 10])

# Axes Limits and Labels
ylabel_value = "Energy Production (in GWh)"
ylim_values = [0, 250]
yticks_values = np.arange(0, 251, 50)

# Labels
label_1 = "Solar"
label_2 = "Wind"
label_3 = "Coal"

# Titles
title_1 = "Renewable Energy Production"
title_2 = "Coal Energy Production"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a subplot layout of 1x2
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5), sharey=True)

color_1 = "#228B22"  # Dark Green
color_2 = "#FFD700"  # Gold
color_3 = "#8B0000"  # Dark Red

# First subplot for Solar and Wind
ax1.errorbar(
    years,
    solar_production,
    yerr=solar_err,
    fmt="o-",
    label=label_1,
    color=color_1,
    capsize=5,
)
ax1.errorbar(
    years,
    wind_production,
    yerr=wind_err,
    fmt="^-",
    label=label_2,
    color=color_2,
    capsize=5,
)
ax1.set_title(title_1)
ax1.set_xticks(years)
ax1.set_xticklabels(years, rotation=45, ha="right", fontsize=12)
ax1.set_yticks(yticks_values)
ax1.set_ylim(ylim_values)
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax1.set_ylabel(ylabel_value, fontsize=16)
ax1.legend(loc="upper left", fontsize=12)

# Second subplot for Coal
ax2.errorbar(
    years,
    coal_production,
    yerr=coal_err,
    fmt="s--",
    label=label_3,
    color=color_3,
    capsize=5,
)
ax2.set_title(title_2)
ax2.set_xticks(years)
ax2.set_xticklabels(years, rotation=45, ha="right", fontsize=12)
ax2.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax2.legend(loc="upper left", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout
plt.tight_layout()
plt.savefig("line_197.pdf", bbox_inches="tight")
