
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulated data for athlete performance scores (out of 100)
athletes_x = np.array(
    ["Basketball", "Soccer", "Tennis", "Swimming", "Running", "Cycling", "Boxing", "Gymnastics"]
)
performance_2022 = np.array([85, 90, 88, 78, 82, 80, 75, 87])
error_2022 = np.array([3, 4, 2, 5, 3, 2, 4, 3])
performance_2023 = np.array([88, 92, 87, 80, 85, 83, 77, 89])
error_2023 = np.array([4, 3, 3, 4, 4, 3, 2, 3])

ylabel_value = "Performance Scores (out of 100)"
xlabel_value = "Sports"
ylim_values = [60, 100]
yticks_values = np.arange(60, 101, 10)

# Labels
label_1 = "Performance 2022"
label_2 = "Performance 2023"

# Titles
title_1 = "Athlete Performance in 2022"
title_2 = "Athlete Performance in 2023"
suptitle = "Athlete Performance in Different Sports Over the Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a subplot layout of 1x2
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 6), sharey=True)

# First subplot for 2022
ax1.errorbar(
    athletes_x,
    performance_2022,
    yerr=error_2022,
    fmt="o-",
    label=label_1,
    color="#1f77b4",  # Blue color
    capsize=5,
    linewidth=2,
    markersize=8,
)
ax1.set_title(title_1)
ax1.set_xticks(athletes_x)
ax1.set_xticklabels(athletes_x, rotation=45, ha="right", fontsize=12)
ax1.set_yticks(yticks_values)
ax1.set_ylim(ylim_values)
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax1.set_ylabel(ylabel_value, fontsize=16)
ax1.legend(loc="upper left", fontsize=12)

# Second subplot for 2023
ax2.errorbar(
    athletes_x,
    performance_2023,
    yerr=error_2023,
    fmt="s-",
    label=label_2,
    color="#ff7f0e",  # Orange color
    capsize=5,
    linewidth=2,
    markersize=8,
)
ax2.set_title(title_2)
ax2.set_xticks(athletes_x)
ax2.set_xticklabels(athletes_x, rotation=45, ha="right", fontsize=12)
ax2.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax2.legend(loc="upper left", fontsize=12)

# Set supertitle for the entire figure
plt.suptitle(suptitle, fontsize=18)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("line_199.pdf", bbox_inches="tight")

