
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting, using random noise to add variability
regions = np.array(['North', 'South', 'East', 'West', 'Central'])
religion_A = np.random.uniform(30, 50, len(regions))
religion_B = np.random.uniform(20, 40, len(regions))
religion_C = np.random.uniform(10, 30, len(regions))
religion_D = np.random.uniform(5, 20, len(regions))

# Axes Limits and Labels
xlabel_value = "Regions"
ylabel_value = "Adherence Rate (%)"

# Labels
label_ReligionA = "Religion A"
label_ReligionB = "Religion B"
label_ReligionC = "Religion C"
label_ReligionD = "Religion D"
title = "Religious Adherence Rates Across Different Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Define colors
color_ReligionA = "#2a9d8f"
color_ReligionB = "#f4a261"
color_ReligionC = "#e76f51"
color_ReligionD = "#264653"

# Plot the data using different styles and colors
plt.plot(
    regions,
    religion_A,
    "o-",
    color=color_ReligionA,
    label=label_ReligionA,
    markerfacecolor=color_ReligionA,
    markersize=8,
    linewidth=2,
)
plt.plot(
    regions,
    religion_B,
    "s--",
    color=color_ReligionB,
    label=label_ReligionB,
    markerfacecolor=color_ReligionB,
    markersize=8,
    linewidth=2,
)
plt.plot(
    regions,
    religion_C,
    "^-",
    color=color_ReligionC,
    label=label_ReligionC,
    markerfacecolor=color_ReligionC,
    markersize=8,
    linewidth=2,
)
plt.plot(
    regions,
    religion_D,
    "x:",
    color=color_ReligionD,
    label=label_ReligionD,
    markerfacecolor=color_ReligionD,
    markersize=8,
    linewidth=2,
)

# Customize the x and y axes limits and labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.xticks(regions)  # Ensure x-ticks match the region values
plt.xlim(left=-0.5, right=len(regions)-0.5)  # Set x-axis limits to accommodate all regions
plt.ylim(bottom=0, top=60)  # Extend y-axis to provide some space above data

# Adjust the legend position
plt.legend(bbox_to_anchor=(1, 0.5), fontsize=12, frameon=True)

# Add grid lines for better readability
plt.grid(True, which="both", ls="--", color="grey", linewidth=1, alpha=0.5)

# Add a title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the plot
plt.tight_layout()
plt.savefig("line_201.pdf", bbox_inches="tight")
