
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data for plotting, based on population metrics
months = np.arange(0, 24, 1)  # 0 to 23 representing two years (24 months)
population_size = np.linspace(1000, 5000, len(months)) + np.random.normal(0, 100, len(months))  # Simulated population size
population_growth_rate = np.random.normal(0.02, 0.005, len(months))  # Simulated population growth rate

# Extracted variables for chart text labels and styles
line_label1 = "Population Size"
line_label2 = "Population Growth Rate"
xlim_values = (0, 23)
ylim_values_population_size = (900, 5100)
ylim_values_growth_rate = (0.01, 0.035)
xlabel_value = "Time (Months)"
ylabel_value_population_size = "Population Size"
ylabel_value_growth_rate = "Growth Rate (%)"
yticks_values_population_size = np.arange(900, 5100, 500)
yticks_values_growth_rate = [0.01, 0.015, 0.02, 0.025, 0.03, 0.035]
title1 = "Monthly Population Size"
title2 = "Monthly Population Growth Rate"
legend_location = "lower center"
legend_bbox_to_anchor = (0.5, -0.2)
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, axs = plt.subplots(2, 1, figsize=(8, 12))  # Use a 2x1 subplot grid for vertical layout

# Define new colors and markers for a fresh look
colors = ["forestgreen", "orangered"]
linestyles = ["-", "--"]
markers = ["o", "s"]
labels = [line_label1, line_label2]

# First subplot for Population Size
axs[0].plot(months, population_size, color=colors[0], linestyle=linestyles[0], marker=markers[0], label=labels[0])
axs[0].set_title(title1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_population_size)
axs[0].set_xlim(xlim_values)
axs[0].set_ylim(ylim_values_population_size)
axs[0].set_yticks(yticks_values_population_size)
axs[0].legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon)
axs[0].grid(True)
axs[0].tick_params(axis="both", which="both", length=0)

# Second subplot for Population Growth Rate
axs[1].plot(months, population_growth_rate, color=colors[1], linestyle=linestyles[1], marker=markers[1], label=labels[1])
axs[1].set_title(title2)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_growth_rate)
axs[1].set_xlim(xlim_values)
axs[1].set_ylim(ylim_values_growth_rate)
axs[1].set_yticks(yticks_values_growth_rate)
axs[1].legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon)
axs[1].grid(True)
axs[1].tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout and visuals
plt.tight_layout()
plt.savefig("line_207.pdf", bbox_inches="tight")
