
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New data for plotting, representing astronomical observations

centuries = list(range(5, 25))
solar_activity_variation = np.sin(np.linspace(0, 5 * np.pi, 20)) + np.random.normal(scale=0.2, size=20)
cosmic_ray_flux = np.cos(np.linspace(0, 5 * np.pi, 20)) + np.random.normal(scale=0.2, size=20)

# Extracted variables
line_label1 = "Solar Activity Variation"
line_label2 = "Cosmic Ray Flux"
xlim_values = (5, 24)
ylim_values = (-2, 2)
xlabel_value = "Centuries"
ylabel_value = "Variation Level"
yticks_values = [-2, -1, 0, 1, 2]
title1 = "Variation in Solar Activity Over Time"
title2 = "Cosmic Ray Flux Over Time"
legend_location = "lower center"
legend_bbox_to_anchor = (0.5, -0.2)
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, axs = plt.subplots(
    2, 1, figsize=(8, 12)  # Increased size for clarity and aesthetics
)  # Use a 2x1 subplot grid for vertical layout

# Define new colors and markers for a fresh look
colors = ["forestgreen", "indigo"]
linestyles = ["-", ":"]
labels = [line_label1, line_label2]

# First subplot
axs[0].plot(
    centuries, solar_activity_variation, color=colors[0], linestyle=linestyles[0], label=labels[0]
)
axs[0].set_title(title1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value)
axs[0].set_xlim(xlim_values)
axs[0].set_ylim(ylim_values)
axs[0].set_yticks(yticks_values)
axs[0].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[0].tick_params(axis="both", which="both", length=0)

# Second subplot
axs[1].plot(
    centuries,
    cosmic_ray_flux,
    color=colors[1],
    linestyle=linestyles[1],
    label=labels[1],
)
axs[1].set_title(title2)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value)
axs[1].set_ylim(ylim_values)
axs[1].set_xlim(xlim_values)
axs[1].set_yticks(yticks_values)
axs[1].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[1].tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout and visuals
plt.tight_layout()
plt.savefig("line_208.pdf", bbox_inches="tight")
