

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new data for a complex scenario
months = np.arange(1, 13, 1)  # Months of the year
temperature = 10 + 15 * np.sin(0.5 * np.pi * (months - 3) / 12) + np.random.normal(0, 1.5, len(months))  # Simulated average temperature
precipitation = 3 + 2 * np.sin(0.5 * np.pi * (months - 3) / 12) + np.random.normal(0, 0.5, len(months))  # Simulated precipitation levels

# Axes Limits and Labels
xlabel_value = "Month"
ylabel_value_1 = "Average Temperature (°C)"
ylabel_value_2 = "Precipitation (cm)"

# Labels
label_1 = "Monthly Average Temperature"
label_2 = "Monthly Precipitation"

# Titles
title = "Monthly Average Temperature and Precipitation Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot temperature data with primary axis
color = "#6a0dad"  # Purple color for temperature
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color)
ax1.plot(months, temperature, label=label_1, color=color, marker="o", linestyle="-", linewidth=2)
ax1.tick_params(axis="y", labelcolor=color)
ax1.set_xticks(months)
ax1.set_title(title)

# Create a second y-axis for precipitation
ax2 = ax1.twinx()  # Instantiate a second axes that shares the same x-axis
color = "#FFD700"  # Gold color for precipitation
ax2.set_ylabel(ylabel_value_2, color=color)  # We already handled the x-label with ax1
ax2.plot(months, precipitation, label=label_2, color=color, marker="s", linestyle="--", linewidth=2)
ax2.tick_params(axis="y", labelcolor=color)

# Add legends to the plot
lines, labels = ax1.get_legend_handles_labels()
lines2, labels2 = ax2.get_legend_handles_labels()
ax1.legend(lines + lines2, labels + labels2, loc="upper center",ncol=2, frameon=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_212.pdf", bbox_inches="tight")

