
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data preparation
days = np.arange(0, 11, 1)
stock_prices = np.random.uniform(100, 200, len(days))
trading_volumes = np.random.uniform(1000, 5000, len(days))
volatility = np.random.uniform(10, 30, len(days))

# Extracted variables
price_label = "Stock Price"
volume_label = "Trading Volume"
volatility_label = "Volatility"

xlim_values = (0, 10)
ylim_values_price = (90, 210)
ylim_values_volume = (900, 5100)
ylim_values_volatility = (5, 35)

yticks_price = np.arange(90, 211, 20)
yticks_volume = np.arange(900, 5101, 1000)
yticks_volatility = np.arange(5, 36, 5)

xlabel_value = "Day"
ylabel_value = "Measurements"

title_price = "Daily Stock Prices"
title_volume = "Daily Trading Volumes"
title_volatility = "Daily Volatility"

legend_location = "upper right"
legend_bbox_to_anchor = (1, 1.15)
legend_frameon = False

grid_linestyle = ":"
grid_alpha = 0.8

tick_params_color = "black"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(8, 12))

# First subplot: Stock Prices
axs[0].plot(
    days,
    stock_prices,
    label=price_label,
    color="#FF7F0E",  # Orange
    linestyle="--",
    marker="^",
)
axs[0].set_title(title_price, y=1.1)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_price)
axs[0].set_yticks(yticks_price)
axs[0].set_ylabel(ylabel_value)
axs[0].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[0].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[0].tick_params(axis="both", which="both", color=tick_params_color)

# Second subplot: Trading Volumes
axs[1].plot(
    days,
    trading_volumes,
    label=volume_label,
    color="#1F77B4",  # Blue
    linestyle="-.",
    marker="D",
)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_volume)
axs[1].set_yticks(yticks_volume)
axs[1].set_title(title_volume, y=1.1)
axs[1].set_ylabel(ylabel_value)
axs[1].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[1].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[1].tick_params(axis="both", which="both", color=tick_params_color)

# Third subplot: Volatility
axs[2].plot(
    days,
    volatility,
    label=volatility_label,
    color="#2CA02C",  # Green
    linestyle="-",
    marker="o",
)
axs[2].set_title(title_volatility, y=1.1)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_volatility)
axs[2].set_yticks(yticks_volatility)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value)
axs[2].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[2].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[2].tick_params(
    axis="both",
    which="both",
    color=tick_params_color,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_215.pdf", bbox_inches="tight")
