

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data preparation
days = list(range(11))
stock_prices = [100, 102, 105, 108, 110, 108, 115, 118, 116, 120, 123]
trading_volume = [1500, 1600, 1550, 1670, 1700, 1650, 1720, 1800, 1780, 1850, 1900]
moving_average = [100, 101, 102.5, 104.5, 106.6, 107.8, 110.6, 113.1, 114.9, 117.2, 119.5]

# Extracted variables
stock_prices_label = "Stock Prices"
trading_volume_label = "Trading Volume"
moving_average_label = "Moving Average"

xlim_values = (0, 10)
ylim_values_stock_prices = (95, 125)
ylim_values_trading_volume = (1400, 2000)
ylim_values_moving_average = (95, 125)

yticks_stock_prices = [95, 105, 115, 125]
yticks_trading_volume = [1400, 1550, 1700, 1850, 2000]
yticks_moving_average = [95, 105, 115, 125]

xlabel_value = "Day"
ylabel_value = "Value"

title_stock_prices = "Stock Prices Over Time"
title_trading_volume = "Trading Volume Over Time"
title_moving_average = "Moving Average Over Time"

legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.15)
legend_frameon = False

grid_linestyle = "--"
grid_alpha = 0.5



# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(6, 9))
tick_params_color = "gray"

# First subplot: Stock Prices
axs[0].plot(
    days,
    stock_prices,
    label=stock_prices_label,
    color="#2ca02c",
    clip_on=False,
    zorder=10,
    linestyle="-",
    marker="o",
)
axs[0].set_title(title_stock_prices, y=1.1)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_stock_prices)
axs[0].set_yticks(yticks_stock_prices)
axs[0].set_ylabel(ylabel_value)
axs[0].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[0].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[0].tick_params(axis="both", which="both", color=tick_params_color)

# Second subplot: Trading Volume
axs[1].plot(
    days,
    trading_volume,
    label=trading_volume_label,
    color="#1f77b4",
    clip_on=False,
    zorder=10,
    linestyle="--",
    marker="x",
)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_trading_volume)
axs[1].set_yticks(yticks_trading_volume)
axs[1].set_title(title_trading_volume, y=1.1)
axs[1].set_ylabel(ylabel_value)
axs[1].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[1].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[1].tick_params(axis="both", which="both", color=tick_params_color)

# Third subplot: Moving Average
axs[2].plot(
    days,
    moving_average,
    label=moving_average_label,
    clip_on=False,
    zorder=10,
    color="#ff7f0e",
    linestyle="-.",
    marker="s",
)
axs[2].set_title(title_moving_average, y=1.1)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_moving_average)
axs[2].set_yticks(yticks_moving_average)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value)
axs[2].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[2].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[2].tick_params(
    axis="both",
    which="both",
    color=tick_params_color,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_216.pdf", bbox_inches="tight")

