

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data preparation

months = list(range(1, 13))  # 12 months

# Generating synthetic weather data
temperature_trend = [0.5 * np.sin(2 * np.pi * (i / 12)) + 22 + (np.random.rand() - 0.5) * 5 for i in months]
rainfall_amount = [50 * np.abs(np.sin((2 * np.pi / 12) * i)) + np.random.rand() * 20 for i in months]
humidity_levels = [0.8 * np.abs(np.sin((2 * np.pi / 12) * i)) + 50 + (np.random.rand() - 0.5) * 10 for i in months]

# Extracted variables
temperature_trend_label = "Temperature Trend"
rainfall_amount_label = "Rainfall Amount"
humidity_levels_label = "Humidity Levels"

xlim_values = (1, 12)
ylim_values_temperature = (15, 30)
ylim_values_rainfall = (0, 70)
ylim_values_humidity = (40, 70)

yticks_temperature = list(range(15, 31, 5))
yticks_rainfall = list(range(0, 71, 10))
yticks_humidity = list(range(40, 71, 10))

xlabel_value = "Months"
ylabel_value = "Value"

title_temperature = "Monthly Temperature Trend"
title_rainfall = "Monthly Rainfall Amount"
title_humidity = "Monthly Humidity Levels"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.15)
legend_frameon = False

grid_linestyle = "--"
grid_alpha = 0.5

tick_params_color = "gray"

# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(6, 9))

# First subplot: Monthly Temperature Trend
axs[0].plot(
    months,
    temperature_trend,
    label=temperature_trend_label,
    color="#1f77b4",
    clip_on=False,
    zorder=10,
    linestyle="--",
    marker="o",
    linewidth=2,
    markersize=6
)
axs[0].set_title(title_temperature, y=1.1)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_temperature)
axs[0].set_yticks(yticks_temperature)
axs[0].set_ylabel(ylabel_value)
axs[0].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[0].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[0].tick_params(axis="both", which="both", color=tick_params_color)

# Second subplot: Monthly Rainfall Amount
axs[1].plot(
    months,
    rainfall_amount,
    label=rainfall_amount_label,
    color="#ff7f0e",
    clip_on=False,
    zorder=10,
    linestyle="-.",
    marker="x",
    linewidth=2,
    markersize=6
)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_rainfall)
axs[1].set_yticks(yticks_rainfall)
axs[1].set_title(title_rainfall, y=1.1)
axs[1].set_ylabel(ylabel_value)
axs[1].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[1].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[1].tick_params(axis="both", which="both", color=tick_params_color)

# Third subplot: Monthly Humidity Levels
axs[2].plot(
    months,
    humidity_levels,
    label=humidity_levels_label,
    clip_on=False,
    zorder=10,
    color="#2ca02c",
    linestyle=":",
    marker="s",
    linewidth=2,
    markersize=6
)
axs[2].set_title(title_humidity, y=1.1)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_humidity)
axs[2].set_yticks(yticks_humidity)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value)
axs[2].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[2].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[2].tick_params(
    axis="both",
    which="both",
    color=tick_params_color,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_217.pdf", bbox_inches="tight")

