

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generating new data for meteorology domain
time = np.linspace(1, 30, 30)

# Simulated data
temperature = np.sin(time / 2) * 10 + 20 + np.random.normal(0, 2, 30)  # Temperature with noise
smoothed_temperature = np.convolve(temperature, np.ones(5) / 5, mode="valid")  # Smoothed data
temperature_change = np.diff(temperature)  # Temperature change data as difference
cumulative_temperature = np.cumsum(temperature)  # Cumulative sum of temperature

# Axes Limits and Labels
xlabel_value = "Time (days)"
ylabel_value_1 = "Temperature (°C)"
ylabel_value_2 = "Change in Temperature (°C)"
ylabel_value_3 = "Cumulative Temperature (°C)"

# Labels
label_1 = "Smoothed Temperature"
label_2 = "Temperature Change"
label_3 = "Cumulative Temperature"

# Titles
title_1 = "Daily Temperature Over One Month"
title_2 = "Temperature Fluctuations"
title_3 = "Cumulative Temperature Over One Month"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(5, 10))

# First subplot: Smoothed Temperature
axs[0].plot(
    time[2:-2],
    smoothed_temperature,
    label=label_1,
    color="blue",
    linestyle="--",
    marker="v",
)
axs[0].set_title(title_1)
axs[0].set_ylabel(ylabel_value_1)
axs[0].legend(loc="upper right")
axs[0].grid(True, linestyle=":", alpha=0.7)

# Second subplot: Temperature Change
axs[1].plot(
    time[1:],
    temperature_change,
    label=label_2,
    color="red",
    linestyle="-.",
    marker="x",
)
axs[1].set_title(title_2)
axs[1].set_ylabel(ylabel_value_2)
axs[1].legend(loc="upper right")
axs[1].grid(True, linestyle=":", alpha=0.7)

# Third subplot: Cumulative Temperature
axs[2].plot(time, cumulative_temperature, label=label_3, color="green", linestyle="-", marker="o")
axs[2].set_title(title_3)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_3)
axs[2].legend(loc="upper right")
axs[2].grid(True, linestyle=":", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_220.pdf", bbox_inches="tight")

