
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Time variable, representing the timeline of tourism trends (e.g., years)
t = np.arange(2000, 2021, 1)  # Years from 2000 to 2020

# Simulated data for different types of tourism
adventure_tourism = np.linspace(1, 5, len(t)) + np.random.normal(0, 0.3, t.shape)
cultural_tourism = 3 + np.sin(t / 2) + np.random.normal(0, 0.3, t.shape)
wellness_tourism = np.log(t - 1999 + 2) + np.random.normal(0, 0.2, t.shape)
eco_tourism = np.exp((t - 2010) / 10) / 20 + np.random.normal(0, 0.1, t.shape)

# Labels for legend
label_adventure_tourism = "Adventure Tourism"
label_cultural_tourism = "Cultural Tourism"
label_wellness_tourism = "Wellness Tourism"
label_eco_tourism = "Eco-Tourism"

# Plot configuration
xlim_values = (2000, 2020)
ylim_values_adventure_cultural = (0, 6)
ylim_values_wellness = (0, 5)
ylim_values_eco = (-0.2, 0.3)

xlabel_value = "Time (Years)"
ylabel_value_tourism = "Interest Level"
ylabel_value_wellness_eco = "Influence Level"

title_adventure = "Trends in Adventure Tourism"
title_cultural = "Trends in Cultural Tourism"
title_wellness = "Growth of Wellness Tourism"
title_eco = "Rise of Eco-Tourism"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(4, 1, figsize=(6, 12))

axs[0].plot(t, adventure_tourism, label=label_adventure_tourism, color="navy", linestyle="--", linewidth=2)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_adventure_cultural)
axs[0].set_title(title_adventure, y=1.1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_tourism)

axs[1].plot(t, cultural_tourism, label=label_cultural_tourism, color="teal", linestyle=":", linewidth=2)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_adventure_cultural)
axs[1].set_title(title_cultural, y=1.1)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_tourism)

axs[2].plot(t, wellness_tourism, label=label_wellness_tourism, color="grey", linestyle="-", linewidth=2)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_wellness)
axs[2].set_title(title_wellness, y=1.1)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_wellness_eco)

axs[3].plot(t, eco_tourism, label=label_eco_tourism, color="darkred", linestyle="-.", linewidth=2)
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(*ylim_values_eco)
axs[3].set_title(title_eco, y=1.1)
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_wellness_eco)

for ax in axs.flat:
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_222.pdf", bbox_inches="tight")
