
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generated EV sales data (Number of vehicles sold over months)
months1 = np.array([1, 2, 3, 4, 5])
sales1 = np.array([150, 170, 180, 160, 190])
variation1 = np.array([5, 7, 6, 8, 9])

months2 = np.array([1, 2, 3, 4])
sales2 = np.array([300, 320, 310, 330])
variation2 = np.array([10, 12, 9, 11])

months3 = np.array([1, 2, 3, 4, 5, 6])
sales3 = np.array([450, 420, 480, 500, 520, 510])
variation3 = np.array([15, 13, 14, 18, 17, 16])

months4 = np.array([1, 2, 3, 4, 5])
sales4 = np.array([220, 245, 255, 240, 230])
variation4 = np.array([8, 9, 10, 7, 6])

# Titles and labels
titles = [
    "Company A - EV Sales Trend",
    "Company B - EV Sales Trend",
    "Company C - EV Sales Trend",
    "Company D - EV Sales Trend",
]
xlabel = "Months"
ylabel = "Number of EVs Sold"
legend_labels = ["EV Sales"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x2 subplots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Flatten the axis array for easy iteration
axs = axs.flatten()

# Setting data for each subplot
data = [(months1, sales1, variation1), (months2, sales2, variation2), (months3, sales3, variation3), (months4, sales4, variation4)]

# Custom colors and styles
colors = ['#2ca02c', '#1f77b4', '#ff7f0e', '#d62728']
markers = ['o', 's', 'D', '^']
linestyles = ['-', '--', '-.', ':']

# Plot with error bars in each subplot
for i, (ax, (x, y, e), title) in enumerate(zip(axs, data, titles)):
    ax.errorbar(
        x, y, yerr=e, fmt=linestyles[i], color=colors[i], ecolor="gray", capsize=5, markersize=6, marker=markers[i]
    )
    ax.set_title(title, fontsize=14)
    ax.set_xlabel(xlabel, fontsize=12)
    ax.set_ylabel(ylabel, fontsize=12)
    ax.grid(True, alpha=0.5)
    ax.set_xticks(x)
    ax.set_yticks(np.linspace(min(y) - max(e), max(y) + max(e), num=5, endpoint=True))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_224.pdf", bbox_inches="tight")
