
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Sample data representing "Historical Weather Data"
# x-axis: Days in a week
# y-axis: Various weather metrics

# Data for temperature
x1 = np.array([1, 2, 3, 4, 5])
y1 = np.array([22, 24, 25, 23, 26])
e1 = np.array([1, 1.5, 1, 0.5, 1.2])

# Data for precipitation
x2 = np.array([1, 2, 3, 4])
y2 = np.array([3, 5, 2, 1])
e2 = np.array([0.5, 0.7, 0.3, 0.4])

# Data for wind speed
x3 = np.array([1, 2, 3, 4, 5, 6])
y3 = np.array([12, 15, 13, 16, 14, 17])
e3 = np.array([1, 1.5, 1, 1.2, 1.3, 1.1])

# Data for humidity
x4 = np.array([1, 2, 3, 4, 5])
y4 = np.array([65, 70, 68, 72, 69])
e4 = np.array([3, 2, 4, 3, 2.5])

# Titles
titles = [
    "(a) Daily Temperature (°C)",
    "(b) Daily Precipitation (mm)",
    "(c) Daily Wind Speed (km/h)",
    "(d) Daily Humidity (%)",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x2 subplots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Flatten the axis array for easy iteration
axs = axs.flatten()

# Setting data for each subplot
data = [(x1, y1, e1), (x2, y2, e2), (x3, y3, e3), (x4, y4, e4)]

# Custom colors and styles
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]
markers = ["o", "s", "D", "^"]

# Plot with error bars in each subplot
for ax, (x, y, e), title, color, marker in zip(axs, data, titles, colors, markers):
    ax.errorbar(
        x, y, yerr=e, fmt=f"-{marker}", color=color, ecolor="gray", 
        elinewidth=1, capsize=5, markersize=7, linestyle='-', linewidth=2
    )
    ax.set_title(title, fontsize=16)
    ax.set_xlabel('Days', fontsize=12)
    ax.set_ylabel('Value', fontsize=12)
    ax.grid(True, which='both', linestyle='--', linewidth=0.5, alpha=0.7)
    ax.set_xticks(np.arange(min(x), max(x) + 1, 1))
    ax.set_yticks(np.linspace(min(y) - min(e), max(y) + max(e), num=5, endpoint=True))

# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_226.pdf", bbox_inches="tight")
