

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Titles and generated data for societal trends
titles = [
    "Urbanization Rate",
    "Literacy Rate",
    "Internet Penetration",
    "Unemployment Rate",
    "Median Age",
    "GDP Growth Rate"
]

# Example X values could represent years or periods
years = [
    np.array([1950, 1960, 1970, 1980, 1990, 2000]),
    np.array([1900, 1920, 1940, 1960, 1980, 2000]),
    np.array([1995, 2000, 2005, 2010, 2015, 2020]),
    np.array([1970, 1980, 1990, 2000, 2010]),
    np.array([1950, 1960, 1970, 1980, 1990, 2000, 2010]),
    np.array([2000, 2005, 2010, 2015, 2020])
]

# Y values could represent influence score, popularity or growth percentage
influence = [
    np.random.uniform(20, 80, size=len(years[0])),
    np.random.uniform(50, 100, size=len(years[1])),
    np.random.uniform(10, 90, size=len(years[2])),
    np.random.uniform(3, 15, size=len(years[3])),
    np.random.uniform(25, 45, size=len(years[4])),
    np.random.uniform(1, 10, size=len(years[5]))
]

# Error margins for historical uncertainty
errors = [
    np.random.uniform(1, 5, size=len(years[0])),
    np.random.uniform(1, 3, size=len(years[1])),
    np.random.uniform(2, 8, size=len(years[2])),
    np.random.uniform(0.5, 2, size=len(years[3])),
    np.random.uniform(1, 4, size=len(years[4])),
    np.random.uniform(0.5, 3, size=len(years[5]))
]
xlabel = "Year"
ylabel = "Influence/Popularity"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(2, 3, figsize=(12, 8))
# Color scheme inspired by classical art
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]

# Line styles and markers
line_styles = ['-', '--', '-.', ':', '-', '--']
markers = ['o', 's', 'D', '^', '*', 'x']

data_pairs = list(zip(years, influence, errors))

for ax, (x, y, e), title, color, line_style, marker in zip(axs.flat, data_pairs, titles, colors, line_styles, markers):
    ax.errorbar(
        x, y, yerr=e, fmt=line_style+marker, color=color, ecolor="lightgray", capsize=5, label=title
    )
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.set_xticks(x)
    ax.set_ylim(min(y) - min(e) - 1, max(y) + max(e) + 1)
    ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_227.pdf", bbox_inches="tight")
