
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)

x1 = np.array([1, 2, 3, 4, 5, 6])
y1 = np.random.uniform(200, 300, size=len(x1))
e1 = np.random.uniform(10, 20, size=len(x1))

x2 = np.array([1, 2, 3, 4, 5, 6])
y2 = np.random.uniform(150, 250, size=len(x2))
e2 = np.random.uniform(10, 20, size=len(x2))

x3 = np.array([1, 2, 3, 4, 5, 6])
y3 = np.random.uniform(50, 100, size=len(x3))
e3 = np.random.uniform(5, 15, size=len(x3))

x4 = np.array([1, 2, 3, 4, 5, 6])
y4 = np.random.uniform(20, 40, size=len(x4))
e4 = np.random.uniform(2, 5, size=len(x4))

x5 = np.array([1, 2, 3, 4, 5, 6])
y5 = np.random.uniform(1000, 1500, size=len(x5))
e5 = np.random.uniform(50, 100, size=len(x5))

x6 = np.array([1, 2, 3, 4, 5, 6])
y6 = np.random.uniform(5, 10, size=len(x6))
e6 = np.random.uniform(0.5, 1.0, size=len(x6))

titles = [
    "Views",
    "Likes",
    "Shares",
    "Comments",
    "Followers",
    "Engagement Rate",
]

xlabel = "Time (Months)"
ylabel = "Metric Value"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(2, 3, figsize=(14, 9))
sports_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
linestyles = ['-', '--', '-.', ':', '-', '--']
markers = ['o', 's', 'D', '^', 'p', '*']

data_pairs = [
    (x1, y1, e1),
    (x2, y2, e2),
    (x3, y3, e3),
    (x4, y4, e4),
    (x5, y5, e5),
    (x6, y6, e6),
]

for ax, (x, y, e), title, color, linestyle, marker in zip(axs.flat, data_pairs, titles, sports_colors, linestyles, markers):
    ax.errorbar(
        x, y, yerr=e, fmt=marker, color=color, ecolor="gray", capsize=5, label=title, linestyle=linestyle
    )
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.set_xticks(x)
    ax.grid(True)
    ax.set_ylim(min(y) - min(e) - 10, max(y) + max(e) + 10)
    ax.legend(loc="upper left")

fig.suptitle("Media Metrics Over Time", fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("line_229.pdf", bbox_inches="tight")

