
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
terrains = ["Flat", "Hilly", "Mountainous", "Urban"]
average_speed_car = [60, 45, 30, 25]
average_speed_bike = [20, 15, 10, 12]
average_speed_bus = [50, 35, 20, 22]
average_speed_train = [80, 70, 60, 55]

error = [5, 5, 5, 5]

# Axes Limits and Labels
xlabel_value = "Terrain Type"
ylabel_value = "Average Speed (km/h)"
ylim_values = [0, 100]

# Titles
titles = ["Car vs Bike", "Bus vs Train", "Car vs Train"]
suptitle="Average Speeds of Different Transportation Modes Across Terrains"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1x3 subplot layout
fig, axs = plt.subplots(1, 3, figsize=(15, 5))

# Titles and setup for subplots
data_pairs = [
    (average_speed_car, average_speed_bike),
    (average_speed_bus, average_speed_train),
    (average_speed_car, average_speed_train),
]
colors_pairs = [("#0077BB", "#CC3311"), ("#009988", "#EE7733"), ("#CC3311", "#EE7733")]
markers_pairs = [('o', 's'), ('^', 'D'), ('s', 'D')]
line_styles_pairs = [('-', '--'), ('-.', ':'), ('--', '-')]

# Plot each condition in a separate subplot
for ax, title, (data1, data2), (color1, color2), (marker1, marker2), (style1, style2) in zip(
    axs, titles, data_pairs, colors_pairs, markers_pairs, line_styles_pairs
):
    ax.errorbar(
        terrains,
        data1,
        yerr=error,
        fmt=marker1+style1,
        color=color1,
        ecolor=color1,
        elinewidth=2,
        capsize=5,
        capthick=2,
        label=f'{title.split(" vs ")[0]}',
        markersize=8,
        linewidth=2,
    )
    ax.errorbar(
        terrains,
        data2,
        yerr=error,
        fmt=marker2+style2,
        color=color2,
        ecolor=color2,
        elinewidth=2,
        capsize=5,
        capthick=2,
        label=f'{title.split(" vs ")[1]}',
        markersize=8,
        linewidth=2,
    )
    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.tick_params(
        axis="both", which="major", length=5, direction="in", top=True, right=True
    )
    ax.legend(loc="upper right", frameon=True)
    ax.set_ylim(ylim_values)
    ax.grid(True, which="major", linestyle="--", linewidth=0.5, alpha=0.5)
    ax.set_title(title)

# Super Title
plt.suptitle(suptitle, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("line_231.pdf", bbox_inches="tight")

