

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
courses = ["Math", "Science", "Art", "History"]
enrollment_past = [150, 120, 90, 60]
enrollment_present = [140, 130, 100, 80]
enrollment_future = [130, 135, 110, 100]  # Additional data for future prediction
enrollment_projection = [135, 125, 105, 95]  # Additional projection data
error = [5, 5, 5, 5]

# Axes Limits and Labels
xlabel_value = "Course"
ylabel_value = "Enrollment Numbers"
ylim_values = [50, 150]

# Titles
titles = ["Past vs Present", "Future vs Projection", "Present vs Future"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1x3 subplot layout
fig, axs = plt.subplots(1, 3, figsize=(12, 4))

# Titles and setup for subplots
data_pairs = [
    (enrollment_past, enrollment_present),
    (enrollment_future, enrollment_projection),
    (enrollment_present, enrollment_future),
]
colors_pairs = [("#66545E", "#556270"), ("#355C7D", "#C06C84"), ("#556270", "#355C7D")]

# Plot each condition in a separate subplot
for ax, title, (data1, data2), (color1, color2) in zip(
    axs, titles, data_pairs, colors_pairs
):
    ax.errorbar(
        courses,
        data1,
        yerr=error,
        fmt="o-",
        color=color1,
        ecolor=color1,
        elinewidth=2,
        capsize=5,
        capthick=2,
        label=f'{title.split(" vs ")[0]}',
    )
    ax.errorbar(
        courses,
        data2,
        yerr=error,
        fmt="s-",
        color=color2,
        ecolor=color2,
        elinewidth=2,
        capsize=5,
        capthick=2,
        label=f'{title.split(" vs ")[1]}',
    )
    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.tick_params(
        axis="both", which="major", length=5, direction="in", top=True, right=True
    )
    ax.legend(loc="upper right", frameon=True)
    ax.set_ylim(ylim_values)
    ax.grid(True, which="major", linestyle="--", linewidth=0.5, alpha=0.5)
    ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_232.pdf", bbox_inches="tight")

