

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Updated data for geography domain (average monthly temperatures in °C)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
city_A = np.array([4, 5, 9, 13, 18, 22, 25, 24, 20, 15, 9, 5])
city_B = np.array([10, 12, 15, 18, 22, 26, 30, 29, 25, 19, 14, 11])
city_C = np.array([-3, -2, 2, 8, 14, 20, 24, 23, 17, 10, 4, 0])

# Axes Limits and Labels
xlabel_value = "Months"
xlim_values = [0, len(months) - 1]

ylabel_value = "Average Temperature (°C)"
ylim_values = [min(city_C) - 2, max(city_B) + 2]

# Labels
label_City_A = "City A"
label_City_B = "City B"
label_City_C = "City C"

# Titles
title = "Monthly Average Temperature in Three Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 3))
ax.plot(
    months,
    city_A,
    "o-",
    label=label_City_A,
    color="#A1C9F1",  # Calming blue
    linewidth=2,
    markersize=8,
)
ax.plot(
    months,
    city_B,
    "s--",
    label=label_City_B,
    color="#F1A1C9",  # Soothing pink
    linewidth=2,
    markersize=8,
)
ax.plot(
    months,
    city_C,
    "^:",
    label=label_City_C,
    color="#A1F1C9",  # Relaxing green
    linewidth=2,
    markersize=8,
)

# Enhancements for visual appeal
ax.set_facecolor("#f5f5f5")  # Light grey background
ax.spines["top"].set_color("none")
ax.spines["right"].set_color("none")
ax.spines["left"].set_color("gray")
ax.spines["bottom"].set_color("gray")

# Setting axis limits and ticks dynamically based on data
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Customizing labels and grid
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(title, fontsize=16)

# Custom legend
ax.legend(loc="upper right", fontsize=12, frameon=True, shadow=True)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, color="grey")

# ===================
# Part 4: Saving Output
# ===================
# Tight layout for better spacing
plt.tight_layout()
plt.savefig("line_233.pdf", bbox_inches="tight")

