
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Updated data
periods = ["19th Century", "Early 20th", "Mid 20th", "Late 20th", "Early 21st"]
landmark_cases = np.array([3, 10, 15, 20, 12])
legislation_passed = np.array([2, 5, 12, 18, 22])
judiciary_reforms = np.array([1, 3, 9, 15, 8])

# Axes Limits and Labels
xlabel_value = "Legal Period"
xlim_values = [0, len(periods) - 1]

ylabel_value = "Significance Level"
ylim_values = [0, 25]

# Labels
label_Landmark = "Landmark Cases"
label_Legislation = "Legislation Passed"
label_Reforms = "Judiciary Reforms"

# Titles
title = "Significance of Legal Events Across Periods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 5))
ax.plot(
    periods,
    landmark_cases,
    "d-",
    label=label_Landmark,
    color="#1f78b4",
    linewidth=2,
    markersize=8,
)
ax.plot(
    periods,
    legislation_passed,
    "o--",
    label=label_Legislation,
    color="#33a02c",
    linewidth=2,
    markersize=8,
)
ax.plot(
    periods,
    judiciary_reforms,
    "s:",
    label=label_Reforms,
    color="#e31a1c",
    linewidth=2,
    markersize=8,
)

# Enhancements for visual appeal
ax.set_facecolor("#f0f0f5")  # Light grey background
ax.spines["top"].set_color("none")
ax.spines["right"].set_color("none")
ax.spines["left"].set_color("gray")
ax.spines["bottom"].set_color("gray")

# Setting axis limits and ticks dynamically based on data
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Customizing labels and grid
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(title, fontsize=16)

# Custom legend
ax.legend(loc="upper left", fontsize=12, frameon=True, shadow=True)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, color="grey")

# ===================
# Part 4: Saving Output
# ===================
# Tight layout for better spacing
plt.tight_layout()
plt.savefig("line_234.pdf", bbox_inches="tight")
