
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Updated domain-specific data
nodes = ["1", "2", "4", "8", "16", "32", "64", "128"]
efficiency = np.array([20, 40, 60, 75, 85, 90, 88, 85])  # Rise then stabilization
accuracy = np.array([50, 55, 60, 70, 75, 80, 82, 82])  # Gradual improvement then plateau
throughput = np.array([10, 30, 60, 80, 70, 50, 30, 15])  # Peak in the middle

# Axes Limits and Labels
xlabel_value = "Number of Nodes"
xlim_values = [0, len(nodes) - 1]

ylabel_value = "Performance Metrics (%)"
ylim_values = [0, max(efficiency) + 5]

# Labels
label_Efficiency = "Efficiency"
label_Accuracy = "Accuracy"
label_Throughput = "Throughput"

# Titles
title = "Performance Metrics Across Different Number of Nodes"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 3))
ax.plot(
    nodes,
    efficiency,
    "D-",
    label=label_Efficiency,
    color="#ff6347",  # Tomato color
    linewidth=2,
    markersize=8,
)
ax.plot(
    nodes,
    accuracy,
    "P--",
    label=label_Accuracy,
    color="#4682b4",  # Steel Blue color
    linewidth=2,
    markersize=8,
)
ax.plot(
    nodes,
    throughput,
    "o:",
    label=label_Throughput,
    color="#32cd32",  # Lime Green color
    linewidth=2,
    markersize=8,
)

# Enhancements for visual appeal
ax.set_facecolor("#f0f8ff")  # Alice Blue background
ax.spines["top"].set_color("none")
ax.spines["right"].set_color("none")
ax.spines["left"].set_color("gray")
ax.spines["bottom"].set_color("gray")

# Setting axis limits and ticks dynamically based on data
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Customizing labels and grid
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(title, fontsize=16)

# Custom legend
ax.legend(loc="upper left", fontsize=10, frameon=True, shadow=True)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, color="grey")

# ===================
# Part 4: Saving Output
# ===================
# Tight layout for better spacing
plt.tight_layout()
plt.savefig("line_235.pdf", bbox_inches="tight")
