
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data setup
decades = np.array([1950, 1960, 1970, 1980, 1990, 2000, 2010])
plato_publications = np.array([5, 10, 15, 20, 25, 30, 35])
aristotle_publications = np.array([8, 10, 12, 15, 20, 25, 30])
empirical_philosophy_influence = np.array([20, 30, 40, 60, 70, 80, 90])
rational_philosophy_influence = np.array([30, 35, 40, 50, 55, 60, 65])

# Axes Limits and Labels
xlabel_value = "Decade"
xlim_values = [1945, 2025]
ylabel_value = "Publications / Influence (%)"
ylim_values_publications = [0, 40]
ylim_values_influence = [0, 100]

# Labels
label_1 = "Plato Publications"
label_2 = "Aristotle Publications"
label_3 = "Empirical Philosophy Influence (%)"
label_4 = "Rational Philosophy Influence (%)"

# Titles
title_1 = "Publications about Plato"
title_2 = "Publications about Aristotle"
title_3 = "Influence of Empirical and Rational Philosophy"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a custom color palette
colors = ["#1abc9c", "#2c3e50", "#16a085", "#95a5a6"]

# Create the 1x3 subplot configuration
fig, axs = plt.subplots(1, 3, figsize=(12, 4))

# Plot customization for a fancy look
marker_styles = ["o", "^", "s", "x"]
line_styles = ["-", "--", "-.", ":"]

# First subplot for Plato Publications
axs[0].plot(
    decades,
    plato_publications,
    label=label_1,
    color=colors[0],
    marker=marker_styles[0],
    linestyle=line_styles[0],
    markersize=8,
    linewidth=2,
)
axs[0].set_title(title_1, fontsize=14)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value, fontsize=12)
axs[0].set_ylim(ylim_values_publications)

# Second subplot for Aristotle Publications
axs[1].plot(
    decades,
    aristotle_publications,
    label=label_2,
    color=colors[1],
    marker=marker_styles[1],
    linestyle=line_styles[1],
    markersize=8,
    linewidth=2,
)
axs[1].set_title(title_2, fontsize=14)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_value, fontsize=12)
axs[1].set_ylim(ylim_values_publications)

# Third subplot for Empirical and Rational Philosophy Influence
axs[2].plot(
    decades,
    empirical_philosophy_influence,
    label=label_3,
    color=colors[2],
    marker=marker_styles[2],
    linestyle=line_styles[2],
    markersize=8,
    linewidth=2,
)
axs[2].plot(
    decades,
    rational_philosophy_influence,
    label=label_4,
    color=colors[3],
    marker=marker_styles[3],
    linestyle=line_styles[3],
    markersize=8,
    linewidth=2,
)
axs[2].set_title(title_3, fontsize=14)
axs[2].set_xlabel(xlabel_value, fontsize=12)
axs[2].set_ylabel(ylabel_value, fontsize=12)
axs[2].set_ylim(ylim_values_influence)

# Set global properties and customize each subplot individually
for ax in axs:
    ax.set_xticks(decades)
    ax.set_xlim(xlim_values)
    ax.legend(loc="lower right", fontsize=8)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no overlap and labels are clearly visible
plt.tight_layout()

# Show the plot
plt.savefig("line_236.pdf", bbox_inches="tight")
