
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Library for numerical operations
import numpy as np

# Seed for reproducibility
np.random.seed(42)

# Decade data
decades = np.array([1900, 1910, 1920, 1930, 1940, 1950])

# Average ratings
ratings_classical = np.array([8.0, 8.1, 8.2, 8.3, 8.4, 8.5])
ratings_impressionist = np.array([7.0, 7.1, 7.2, 7.3, 7.4, 7.5])
ratings_modern = np.array([6.5, 6.6, 6.7, 6.8, 6.9, 7.0])
ratings_contemporary = np.array([7.5, 7.4, 7.3, 7.2, 7.1, 7.0])

# Cumulative exhibition counts
exhibitions_classical = np.array([20, 50, 80, 110, 140, 170])
exhibitions_impressionist = np.array([10, 30, 60, 90, 120, 150])
exhibitions_modern = np.array([5, 20, 40, 70, 100, 130])
exhibitions_contemporary = np.array([2, 10, 25, 50, 80, 120])

# Axes Limits and Labels
xlabel_value = "Decades After 1900"
xlim_values = [1890, 1960]
ylabel_ratings = "Average Rating"
ylabel_exhibitions = "Cumulative Exhibition Count"
ylim_ratings = [6.0, 9.0]
ylim_exhibitions = [0, 200]

# Labels for legends
label_classical = "Classical"
label_impressionist = "Impressionist"
label_modern = "Modern"
label_contemporary = "Contemporary"

# Titles for subplots
title_ratings = "Average Ratings Over Decades"
title_exhibitions = "Cumulative Exhibition Count Over Decades"

# Super title for the overall plots
supertitle = "Art Genre Performance Over Decades"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a custom color palette
colors = ["#FF5733", "#33FF57", "#3357FF", "#FF33A6"]

# Create the 1x2 subplot configuration
fig, axs = plt.subplots(1, 2, figsize=(12, 5))

# Plot customization for a fancy look
marker_styles = ["o", "^", "s", "x"]
line_styles = ["-", "--", ":", "-."]

# First subplot for average ratings
axs[0].plot(
    decades,
    ratings_classical,
    label=label_classical,
    color=colors[0],
    marker=marker_styles[0],
    linestyle=line_styles[0],
    markersize=8,
    linewidth=2,
)
axs[0].plot(
    decades,
    ratings_impressionist,
    label=label_impressionist,
    color=colors[1],
    marker=marker_styles[1],
    linestyle=line_styles[1],
    markersize=8,
    linewidth=2,
)
axs[0].plot(
    decades,
    ratings_modern,
    label=label_modern,
    color=colors[2],
    marker=marker_styles[2],
    linestyle=line_styles[2],
    markersize=8,
    linewidth=2,
)
axs[0].plot(
    decades,
    ratings_contemporary,
    label=label_contemporary,
    color=colors[3],
    marker=marker_styles[3],
    linestyle=line_styles[3],
    markersize=8,
    linewidth=2,
)
axs[0].set_title(title_ratings, fontsize=14)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_ratings, fontsize=12)

# Second subplot for exhibition counts
axs[1].plot(
    decades,
    exhibitions_classical,
    label=label_classical,
    color=colors[0],
    marker=marker_styles[0],
    linestyle=line_styles[0],
    markersize=8,
    linewidth=2,
)
axs[1].plot(
    decades,
    exhibitions_impressionist,
    label=label_impressionist,
    color=colors[1],
    marker=marker_styles[1],
    linestyle=line_styles[1],
    markersize=8,
    linewidth=2,
)
axs[1].plot(
    decades,
    exhibitions_modern,
    label=label_modern,
    color=colors[2],
    marker=marker_styles[2],
    linestyle=line_styles[2],
    markersize=8,
    linewidth=2,
)
axs[1].plot(
    decades,
    exhibitions_contemporary,
    label=label_contemporary,
    color=colors[3],
    marker=marker_styles[3],
    linestyle=line_styles[3],
    markersize=8,
    linewidth=2,
)
axs[1].set_title(title_exhibitions, fontsize=14)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_exhibitions, fontsize=12)

# Set global properties and customize each subplot individually
for ax in axs:
    ax.set_xticks(decades)
    ax.set_xlim(xlim_values)
    ax.legend(loc="upper left", ncol=2,fontsize=10)

# Set super title
plt.suptitle(supertitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no overlap and labels are clearly visible
plt.tight_layout(rect=[0, 0.03, 1, 0.95])

# Show the plot
plt.savefig("line_237.pdf", bbox_inches="tight")
