

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulated data for social media content engagement
content_types = ["Meme", "Video", "Article", "Podcast"]
like_rate_basic = np.array([0.65, 0.70, 0.55, 0.50])
like_rate_advanced = np.array([0.75, 0.78, 0.60, 0.55])
share_rate_basic = np.array([0.25, 0.35, 0.20, 0.15])
share_rate_advanced = np.array([0.30, 0.40, 0.25, 0.20])
comment_rate_basic = np.array([0.15, 0.18, 0.10, 0.08])
comment_rate_advanced = np.array([0.20, 0.22, 0.15, 0.12])
view_rate_basic = np.array([0.85, 0.90, 0.75, 0.70])
view_rate_advanced = np.array([0.90, 0.95, 0.80, 0.75])

# Axes Limits and Labels
xlabel_value = "Content Type"
ylabel_value = "Rate (%)"

# Labels
label_1 = " (Basic)"
label_2 = " (Advanced)"
label_3 = "Like Rate vs. Content Type"
label_4 = "Share Rate vs. Content Type"
label_5 = "Comment Rate vs. Content Type"
label_6 = "View Rate vs. Content Type"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 2x2 grid
fig, axs = plt.subplots(2, 2, figsize=(12, 9))

# Custom colors for the plots
colors = ["navy", "mediumpurple", "darkgreen", "teal"]

# Function to plot the data
def plot_data(ax, x, y1, y2, title, marker1, marker2, color1, color2):
    ax.plot(
        x,
        y1,
        marker=marker1,
        markersize=8,
        linewidth=2,
        linestyle='-',
        color=color1,
        label=f"{title}{label_1}",
    )
    ax.plot(
        x,
        y2,
        marker=marker2,
        markersize=8,
        linewidth=2,
        linestyle='--',
        color=color2,
        label=f"{title}{label_2}",
    )
    ax.set_title(title, fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel_value, fontsize=12)
    ax.legend(loc="best", fontsize=10, frameon=True, shadow=True)
    ax.grid(True, linestyle="--", alpha=0.5)

# Assigning data to each subplot
plot_data(
    axs[0, 0],
    content_types,
    like_rate_basic,
    like_rate_advanced,
    label_3,
    "o",
    "s",
    colors[0],
    colors[1],
)
plot_data(
    axs[0, 1],
    content_types,
    share_rate_basic,
    share_rate_advanced,
    label_4,
    "^",
    "d",
    colors[2],
    colors[3],
)
plot_data(
    axs[1, 0],
    content_types,
    comment_rate_basic,
    comment_rate_advanced,
    label_5,
    ">",
    "<",
    colors[1],
    colors[2],
)
plot_data(
    axs[1, 1],
    content_types,
    view_rate_basic,
    view_rate_advanced,
    label_6,
    "p",
    "*",
    colors[3],
    colors[0],
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plots
plt.tight_layout()
plt.savefig("line_239.pdf", bbox_inches="tight")
