
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Simulated weather data
np.random.seed(0)

# Time of day (hours)
hours = np.array([0, 4, 8, 12, 16, 20])

# Temperature (°C)
temperature_morning = np.array([20, 15, 10, 15, 20, 25])
temperature_afternoon = np.array([22, 18, 14, 18, 22, 28])

# Humidity (%)
humidity_morning = np.array([85, 80, 75, 70, 65, 60])
humidity_afternoon = np.array([80, 75, 70, 65, 60, 55])

# Precipitation (mm/h)
precipitation_morning = np.array([0, 1, 2, 3, 2, 1])
precipitation_afternoon = np.array([1, 2, 3, 4, 3, 2])

# Wind Speed (km/h)
wind_speed_morning = np.array([5, 10, 15, 20, 15, 10])
wind_speed_afternoon = np.array([10, 15, 20, 25, 20, 15])

# Axes Limits and Labels
xlabel_value = "Hours of the Day"
ylabel_value_temperature = "Temperature (°C)"
ylabel_value_humidity = "Humidity (%)"
ylabel_value_precipitation = "Precipitation (mm/h)"
ylabel_value_wind_speed = "Wind Speed (km/h)"

# Labels
label_temperature = "Temperature"
label_humidity = "Humidity"
label_precipitation = "Precipitation"
label_wind_speed = "Wind Speed"

# Plot Titles
title_temperature = "Temperature vs. Hours of the Day"
title_humidity = "Humidity vs. Hours of the Day"
title_precipitation = "Precipitation vs. Hours of the Day"
title_wind_speed = "Wind Speed vs. Hours of the Day"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 2x2 grid
fig, axs = plt.subplots(2, 2, figsize=(12, 9))

# Custom colors for the plots
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Function to plot the data
def plot_data(ax, x, y1, y2, title, ylabel, labels, marker1, marker2, color1, color2):
    ax.plot(
        x,
        y1,
        marker=marker1,
        markersize=8,
        linewidth=2,
        color=color1,
        label=f"{labels[0]} (Morning)",
    )
    ax.plot(
        x,
        y2,
        marker=marker2,
        markersize=8,
        linewidth=2,
        color=color2,
        label=f"{labels[1]} (Afternoon)",
    )
    ax.set_title(title, fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel, fontsize=12)
    ax.legend(loc="best", fontsize=10, frameon=True, shadow=True)
    ax.grid(True, linestyle="--", alpha=0.5)

# Assigning data to each subplot
plot_data(
    axs[0, 0],
    hours,
    temperature_morning,
    temperature_afternoon,
    title_temperature,
    ylabel_value_temperature,
    [label_temperature, label_temperature],
    "o",
    "s",
    colors[0],
    colors[1],
)
plot_data(
    axs[0, 1],
    hours,
    humidity_morning,
    humidity_afternoon,
    title_humidity,
    ylabel_value_humidity,
    [label_humidity, label_humidity],
    "^",
    "d",
    colors[2],
    colors[3],
)

# Adding more data plots for thorough representation
plot_data(
    axs[1, 0],
    hours,
    precipitation_morning,
    precipitation_afternoon,
    title_precipitation,
    ylabel_value_precipitation,
    [label_precipitation, label_precipitation],
    "v",
    "x",
    colors[1],
    colors[0],
)
plot_data(
    axs[1, 1],
    hours,
    wind_speed_morning,
    wind_speed_afternoon,
    title_wind_speed,
    ylabel_value_wind_speed,
    [label_wind_speed, label_wind_speed],
    "p",
    "*",
    colors[3],
    colors[2],
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plots
plt.tight_layout()
plt.savefig("line_240.pdf", bbox_inches="tight")
