
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Enhanced seaborn style for a fancier look
days = np.linspace(0, 200, 200)

# Simulated data representing travel distances for two modes of transport
car_travel = np.linspace(30, 200, 200) * (1 + np.random.normal(0, 0.05, 200))
bicycle_travel = np.linspace(5, 30, 200) * (1 + np.random.normal(0, 0.05, 200))

# Axes Limits and Labels
xlabel_value = "Days of Travel"
ylabel_value = "Distance Traveled (km)"
ylim_values = [0, 220]

# Labels
labels = ["Car Travel", "Bicycle Travel"]
title="Travel Progress "
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1x2 subplot layout
fig, axs = plt.subplots(1, 2, figsize=(12, 6))

colors = ["#2ca02c", "#1f77b4"]  # Green and blue colors for the lines

# Plot the data in each subplot
for i, ax in enumerate(axs.flat):
    ax.plot(
        days,
        car_travel * (1 + 0.05 * np.random.randn(1)),
        label=labels[0],
        color=colors[0],
        marker="s",
        markersize=4,
        linewidth=2,
        linestyle="--"
    )
    ax.plot(
        days,
        bicycle_travel * (1 + 0.05 * np.random.randn(1)),
        label=labels[1],
        color=colors[1],
        marker="o",
        markersize=4,
        linewidth=2,
        linestyle="-."
    )
    ax.set_title(f"{title}{i+1}")
    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.set_ylim(ylim_values)  # Ensure consistent y-axis limits
    ax.legend(loc="upper left", frameon=True)  # Add a legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_242.pdf", bbox_inches="tight")
