

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

days = np.linspace(0, 200, 200)

# Simulated temperature data
max_temp = 25 + 10 * np.sin(days/20) + np.random.normal(0, 2, 200)
min_temp = 10 + 5 * np.sin(days/20) + np.random.normal(0, 2, 200)

# Axes Limits and Labels
xlabel_value = "Days"
ylabel_value = "Temperature (°C)"
ylim_values = [-10, 40]

# Labels
labels = ["Max Temperature", "Min Temperature"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1x2 subplot layout
fig, axs = plt.subplots(1, 2, figsize=(12, 5))

colors = ["#2ca02c", "#ff7f0e"]  # Green for max, orange for min

# Plot the data in each subplot
for i, ax in enumerate(axs.flat):
    ax.plot(
        days,
        max_temp * (1 + 0.05 * np.random.randn(1)),
        label=labels[0],
        color=colors[0],
        marker="o",
        markersize=4,
        linewidth=2,
        linestyle='-',
    )
    ax.plot(
        days,
        min_temp * (1 + 0.05 * np.random.randn(1)),
        label=labels[1],
        color=colors[1],
        marker="s",
        markersize=4,
        linewidth=2,
        linestyle='--',
    )
    ax.set_title(f"Metric {i+1}: Temperature Trends")
    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.set_ylim(ylim_values)  # Ensure consistent y-axis limits
    ax.legend(loc="upper left", frameon=True)  # Add a legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_243.pdf", bbox_inches="tight")

