
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
iterations = np.linspace(2000, 2020, 21)  # Years from 2000 to 2020
base_data_1 = np.linspace(40, 70, 21) + np.random.normal(0, 5, 21)  # Leader A Approval Rating
ours_data_1 = np.abs(60 + 10 * np.sin(np.linspace(0, 3 * np.pi, 21)) + np.random.normal(0, 5, 21))  # Leader B Approval Rating

# Axes Limits and Labels
xlabel_value = "Years"
ylabel_value = "Approval Rating (%)"
ylim_values = [0, 100]

# Labels
label_Base_Model = "Leader A Approval Rating"
label_Our_Model = "Leader B Approval Rating"

# Titles
title = "Political Approval Ratings (2000-2020)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Customization options
base_color = "saddlebrown"
ours_color = "goldenrod"
base_marker = "s"
ours_marker = "^"
base_style = "--"
ours_style = "-."

# Create a figure and axis
fig, ax = plt.subplots(figsize=(7, 5))

# Plot the data
ax.plot(
    iterations,
    base_data_1,
    label=label_Base_Model,
    color=base_color,
    marker=base_marker,
    markersize=7,
    linestyle=base_style,
    linewidth=2,
)
ax.plot(
    iterations,
    ours_data_1,
    label=label_Our_Model,
    color=ours_color,
    marker=ours_marker,
    markersize=7,
    linestyle=ours_style,
    linewidth=2,
    alpha=0.8,
)

# Enhance the plot with a title, labels, and legend
ax.set_title(title)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

# Add a legend to the plot
ax.set_ylim(ylim_values)

# Show the plot
ax.legend(loc="upper left", frameon=True, shadow=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig("line_247.pdf", bbox_inches="tight")
