
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the plot
weeks = np.arange(1, 29)
caloric_intake_data = 2500 + 400 * np.sin(2 * np.pi * weeks / len(weeks)) + np.random.normal(0, 100, len(weeks))
weight_change_data = 0.5 * np.cos(2 * np.pi * weeks / len(weeks)) - 0.05 * weeks + np.random.normal(0, 0.2, len(weeks))

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value_1 = "Caloric Intake (Calories)"
ylabel_value_2 = "Weight Change (kg)"
ylim_values = [-3, 3500]

# Labels
label_1 = "Caloric Intake"
label_2 = "Weight Change"

# Titles
title = "Caloric Intake and Weight Change Over Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot the data on the primary y-axis
color_1 = "darkgreen"
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color_1)
ax1.plot(weeks, caloric_intake_data, label=label_1, color=color_1, marker='s', linestyle='-', linewidth=2)
ax1.tick_params(axis='y', labelcolor=color_1)
ax1.set_ylim([1500, 3200])

# Create a secondary y-axis and plot the data
ax2 = ax1.twinx()
color_2 = "darkorange"
ax2.set_ylabel(ylabel_value_2, color=color_2)
ax2.plot(weeks, weight_change_data, label=label_2, color=color_2, marker='^', linestyle='--', linewidth=2)
ax2.tick_params(axis='y', labelcolor=color_2)
ax2.set_ylim([-2, 2])

# Add a legend to the plot
ax1.legend(loc='upper left')
ax2.legend(loc='upper right')

# Customize the plot with a title, grid, and background color
ax1.set_facecolor("whitesmoke")
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Set the title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_249.pdf", bbox_inches="tight")
