

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
weeks = np.arange(1, 29)

# Simulating educational data
test_scores = 65 + 5 * np.sin(2 * np.pi * weeks / len(weeks)) + 0.5 * weeks + np.random.normal(0, 5, len(weeks))
attendance_rates = 90 + 5 * np.cos(2 * np.pi * weeks / len(weeks)) - 0.1 * weeks + np.random.normal(0, 3, len(weeks))

# Axes Labels
xlabel_value = "Weeks"
ylabel_value_1 = "Average Test Scores"
ylabel_value_2 = "Attendance Rate (%)"
ylim_test_scores = [50, 100]
ylim_attendance = [70, 100]

# Labels
label_test_scores = "Test Scores"
label_attendance = "Attendance Rate"

# Titles
title = "Student Test Scores and Attendance Rates Over Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot the test scores data on the primary y-axis
color_test_scores = "#FF5733"  # Orange
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color_test_scores)
ax1.plot(weeks, test_scores, label=label_test_scores, color=color_test_scores, marker="o", linestyle="-", linewidth=2)
ax1.tick_params(axis="y", labelcolor=color_test_scores)
ax1.set_ylim(ylim_test_scores)

# Create a secondary y-axis and plot the attendance data
ax2 = ax1.twinx()
color_attendance = "#33A2FF"  # Teal
ax2.set_ylabel(ylabel_value_2, color=color_attendance)
ax2.plot(weeks, attendance_rates, label=label_attendance, color=color_attendance, marker="x", linestyle="--", linewidth=2)
ax2.tick_params(axis="y", labelcolor=color_attendance)
ax2.set_ylim(ylim_attendance)

# Add legends to the plot
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Customize the plot with a title, grid, and background color
ax1.set_facecolor("whitesmoke")
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Set the title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()  
plt.savefig("line_250.pdf", bbox_inches="tight")

