

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set the random seed for reproducibility
np.random.seed(0)

weeks = np.arange(1, 29)

# Generate simulated media consumption data
tv_hours = 12 + 5 * np.sin(2 * np.pi * weeks / 52) + np.random.normal(0, 1, len(weeks))
social_media_hours = 7 + 3 * np.cos(3 * np.pi * weeks / 52) + np.random.normal(0, 1.5, len(weeks))

# Calculate the upper and lower bounds for the confidence interval
tv_hours_upper = tv_hours + 1
tv_hours_lower = tv_hours - 1
social_media_hours_upper = social_media_hours + 1.5
social_media_hours_lower = social_media_hours - 1.5

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Hours"

# Labels
label_tv = "TV Watching Hours"
label_social_media = "Social Media Usage Hours"

# Titles
title = "Weekly Media Consumption"
title_2 = "TV and Social Media Usage Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the TV watching data line and fill the confidence interval
ax.plot(
    weeks, 
    tv_hours, 
    label=label_tv, 
    color="royalblue", 
    marker="^", 
    linestyle="-", 
    linewidth=2
)
ax.fill_between(
    weeks, tv_hours_lower, tv_hours_upper, color="royalblue", alpha=0.1
)

# Plot the social media usage data line and fill the confidence interval
ax.plot(
    weeks,
    social_media_hours,
    label=label_social_media,
    color="forestgreen",
    marker="s",
    linestyle="--",
    linewidth=2
)
ax.fill_between(
    weeks, social_media_hours_lower, social_media_hours_upper, color="forestgreen", alpha=0.1
)

# Customize the plot with labels, title, and legend
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title, fontsize=16)
ax.legend()

# Add grid to the plot
ax.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_252.pdf", bbox_inches="tight")

