

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
weeks = np.arange(1, 29)
temperature = np.clip(20 + 10 * np.sin(weeks * 0.2) + np.random.normal(0, 0.5, len(weeks)), 10, 30)
rainfall = np.clip(50 + 20 * np.sin(weeks * 0.15) + np.random.normal(0, 2, len(weeks)), 20, 80)
humidity = np.clip(60 + 10 * np.cos(weeks * 0.1) + np.random.normal(0, 1, len(weeks)), 50, 70)

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Metric Value"

# Labels
label_temperature = "Temperature (°C)"
label_rainfall = "Rainfall (mm)"
label_legend = ["Temperature (°C)", "Rainfall (mm)", "Humidity (%)"]

# Titles
title = "Weather Metrics Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(12, 8))

# Colors
temperature_color = "dodgerblue"
rainfall_color = "orange"
humidity_color = "forestgreen"

# Plot the temperature
ax.plot(weeks, temperature, label=label_temperature, color=temperature_color, marker='o', linewidth=2)

# Plot the rainfall level with a gradient color
for i in range(len(weeks) - 1):
    ax.plot(
        weeks[i : i + 2],
        rainfall[i : i + 2],
        linestyle="-",
        linewidth=2,
        color=plt.cm.plasma(i / len(weeks)),
    )

# Plot the humidity index
ax.plot(weeks, humidity, label=label_rainfall, color=humidity_color, linestyle="--", linewidth=2)

# Customize the plot with labels, title, and legend
ax.set_title(title, fontsize=18)
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# Add a legend to the plot
custom_lines = [
    plt.Line2D([0], [0], color=temperature_color, lw=4, marker='o'),
    plt.Line2D([0], [0], color=rainfall_color, lw=4),
    plt.Line2D([0], [0], color=humidity_color, lw=4, linestyle="--"),
]
ax.legend(
    custom_lines,
    label_legend,
    fontsize=12,
)

# Add a grid to the plot
ax.set_facecolor("lavenderblush")
ax.grid(True, which="both", linestyle=":", linewidth=0.75, color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_257.pdf", bbox_inches="tight")

