

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for the new domain - geography (average monthly rainfall in mm)

months_extended = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
region_a = [78, 62, 55, 73, 81, 90, 105, 110, 85, 74, 65, 70]
region_b = [45, 48, 60, 65, 72, 85, 95, 100, 78, 68, 55, 50]
region_c = [30, 32, 40, 50, 55, 60, 70, 75, 60, 50, 40, 35]
region_d = [20, 22, 30, 35, 40, 45, 50, 55, 45, 40, 35, 30]

# Labels and plot types
line_label_region_a = "Region A"
line_label_region_b = "Region B"
line_label_region_c = "Region C"
line_label_region_d = "Region D"

# Plot configuration
xlim_values = [0, 11]  # Months are from 0 to 11
ylim_values = [0, 120]
xlabel_value = "Month"
ylabel_value = "Average Monthly Rainfall (mm)"
xticks_values = np.arange(0, 12, 1)
yticks_values = np.arange(0, 121, 20)
xtickslabel_values = months_extended
ytickslabel_values = None  # Not explicitly set in the code
title_value = "Average Monthly Rainfall in Different Regions Over a Year"
axhiline_values = None  # Not explicitly set in the code
axvline_values = None  # Not explicitly set in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(12, 6))
plt.plot(
    months_extended,
    region_a,
    marker="o",
    markersize=10,
    color="#1f77b4",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_region_a,
    linewidth=2.5,
    linestyle="-",
)
plt.plot(
    months_extended,
    region_b,
    marker="s",
    markersize=10,
    color="#ff7f0e",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_region_b,
    linewidth=2.5,
    linestyle="--",
)
plt.plot(
    months_extended,
    region_c,
    marker="D",
    markersize=10,
    color="#2ca02c",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_region_c,
    linewidth=2.5,
    linestyle=":",
)
plt.plot(
    months_extended,
    region_d,
    marker="v",
    markersize=10,
    color="#d62728",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_region_d,
    linewidth=2.5,
    linestyle="-.",
)

# Customize the plot with labels, title, and legend
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Customize the x-axis ticks
plt.xticks(xticks_values, xtickslabel_values)
plt.xlim(xlim_values)

# Add a grid to the plot
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.tick_params(axis="x", which="both", length=0)
plt.title(title_value, fontsize=18)
plt.legend(
    frameon=False,
    fontsize=12,
    loc="upper left",
    borderpad=1,
    ncol=1,
)

# Add a grid to the plot
plt.grid(True, linestyle="-", linewidth=0.5, axis="y")

# Set the background color of the plot
ax = plt.gca()
ax.set_facecolor(
    mcolors.LinearSegmentedColormap.from_list("custom", ["#f0f9e8", "#ffffff"])(0.8)
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_260.pdf", bbox_inches="tight")
