
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)  # For reproducibility

# Simulate the data for communication technology trends
years = np.arange(1, 11)
trend_5g = np.linspace(10, 80, 10) + np.random.normal(0, 5, 10)
trend_fiber_optic = np.linspace(40, 90, 10) + np.random.normal(0, 4, 10)
trend_satellite_internet = np.linspace(5, 30, 10) + np.random.normal(0, 3, 10)
trend_broadband = np.linspace(50, 95, 10) + np.random.normal(0, 4, 10)

# Axes Limits and Labels
xlabel_value = "Year"
xticks_values = np.arange(1, 11, 1)

ylabel_value = "Adoption/Performance (%)"
ylim_values = [0, 100]

# Labels
label_5G = "5G Adoption"
label_Fiber_Optic = "Fiber Optic Usage"
label_Satellite_Internet = "Satellite Internet Adoption"
label_Broadband = "Broadband Penetration"

# Titles
title_1 = "Adoption Trends: 5G vs Fiber Optic"
title_2 = "Adoption Trends: Satellite Internet vs Broadband"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Define new colors
colors = {
    "5g": "#1f77b4",
    "fiber_optic": "#ff7f0e",
    "satellite_internet": "#2ca02c",
    "broadband": "#d62728"
}

# Plot the data in each subplot
ax1.plot(
    years,
    trend_5g,
    marker="o",
    markersize=7,
    color=colors["5g"],
    mfc="w",
    mew=2,
    label=label_5G,
    linestyle='-',
    linewidth=2,
)
ax1.plot(
    years,
    trend_fiber_optic,
    marker="s",
    markersize=7,
    color=colors["fiber_optic"],
    mfc="w",
    mew=2,
    label=label_Fiber_Optic,
    linestyle='--',
    linewidth=2,
)
ax1.set_title(title_1, fontsize=14)
ax1.set_xlabel(xlabel_value, fontsize=12)
ax1.set_ylabel(ylabel_value, fontsize=12)
ax1.set_ylim(ylim_values)
ax1.set_xticks(xticks_values)
ax1.legend(fontsize=10)
ax1.grid(True, linestyle="--", alpha=0.6)

ax2.plot(
    years,
    trend_satellite_internet,
    marker="d",
    markersize=7,
    color=colors["satellite_internet"],
    mfc="w",
    mew=2,
    label=label_Satellite_Internet,
    linestyle='-.',
    linewidth=2,
)
ax2.plot(
    years,
    trend_broadband,
    marker="^",
    markersize=7,
    color=colors["broadband"],
    mfc="w",
    mew=2,
    label=label_Broadband,
    linestyle=':',
    linewidth=2,
)
ax2.set_title(title_2, fontsize=14)
ax2.set_xlabel(xlabel_value, fontsize=12)
ax2.set_ylabel(ylabel_value, fontsize=12)
ax2.set_ylim(ylim_values)
ax2.set_xticks(xticks_values)
ax2.legend(fontsize=10)
ax2.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_263.pdf", bbox_inches="tight")
