
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for the plot
years = np.array([2015, 2017, 2019, 2021, 2023])

# Simulated data for technology companies
data = {
    "TechCorp": (
        np.linspace(10, 50, 5) + np.random.normal(0, 5, 5),  # User Base in millions
        np.linspace(1, 5, 5) + np.random.normal(0, 0.5, 5),   # Revenue in billions
    ),
    "InnovateX": (
        np.linspace(15, 45, 5) + np.random.normal(0, 5, 5),
        np.linspace(2, 6, 5) + np.random.normal(0, 0.5, 5),
    ),
    "NextGen Solutions": (
        np.linspace(20, 55, 5) + np.random.normal(0, 5, 5),
        np.linspace(3, 7, 5) + np.random.normal(0, 0.5, 5),
    ),
    "FutureSoft": (
        np.linspace(25, 60, 5) + np.random.normal(0, 5, 5),
        np.linspace(4, 8, 5) + np.random.normal(0, 0.5, 5),
    ),
}

# Axes Limits and Labels
xlabel_value = "Year"
xticks_values = np.arange(2015, 2026, 2)

ylabel_value = "Value"
ylim_values = [0, 70]

# Labels
label_1 = " User Base (millions)"
label_2 = " Revenue (billions)"
title="Growth Over Time"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(10, 8))

# Color and marker configuration
colors = ["#2a9d8f", "#e76f51", "#f4a261", "#264653"]
markers = ["o", "v", "s", "D"]

# Plot the data for each company
for i, (company, (user_base, revenue)) in enumerate(data.items()):
    ax = plt.subplot(2, 2, i + 1)
    ax.plot(
        years,
        user_base,
        marker=markers[i],
        color=colors[i],
        markerfacecolor=colors[i],
        linewidth=2,
        markersize=6,
        label=f"{company}{label_1}",
    )
    ax.plot(
        years,
        revenue,
        marker=markers[i],
        linestyle='--',
        color=colors[i],
        alpha=0.6,
        linewidth=2,
        markersize=6,
        label=f"{company}{label_2}",
    )
    ax.fill_between(
        years, user_base - 5, user_base + 5, color=colors[i], alpha=0.1
    )
    ax.fill_between(
        years, revenue - 0.5, revenue + 0.5, color=colors[i], alpha=0.1
    )
    ax.set_title(f"{company} {title}", fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel_value, fontsize=12)
    ax.set_ylim(ylim_values)
    ax.set_xticks(xticks_values)
    ax.legend()
    ax.grid(True, linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_266.pdf", bbox_inches="tight")
