
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
time_intervals = np.array([0, 250, 500, 750, 1000, 1250, 1500, 1750, 2000])

# Simulated data for the sensor readings
data = {
    "sensor_1": (
        np.linspace(20, 80, 9) + np.random.normal(0, 5, 9),  # Temperature in Celsius
        np.linspace(30, 50, 9) + np.random.normal(0, 5, 9),  # Humidity in %
    ),
    "sensor_2": (
        np.linspace(25, 85, 9) + np.random.normal(0, 5, 9),
        np.linspace(28, 48, 9) + np.random.normal(0, 5, 9),
    ),
    "sensor_3": (
        np.linspace(22, 82, 9) + np.random.normal(0, 5, 9),
        np.linspace(32, 52, 9) + np.random.normal(0, 5, 9),
    ),
    "sensor_4": (
        np.linspace(18, 78, 9) + np.random.normal(0, 5, 9),
        np.linspace(35, 55, 9) + np.random.normal(0, 5, 9),
    ),
}

# Axes Limits and Labels
xlabel_value = "Time Intervals (seconds)"
xticks_values = np.arange(0, 2250, 250)

ylabel_1_value = "Temperature (Celsius)"
ylabel_2_value = "Humidity (%)"
ylim_1_values = [10, 90]
ylim_2_values = [10, 100]

# Labels
label_1 = " - Temperature"
label_2 = " - Humidity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(12, 10))

# Plot the data for each sensor
colors = ["#1f77b4", "#2ca02c", "#ff7f0e", "#d62728"]
markers = ["o", "s", "^", "d"]

# Plot the data for each sensor
for i, (key, (series1, series2)) in enumerate(data.items()):
    ax = plt.subplot(2, 2, i + 1)
    ax.plot(
        time_intervals,
        series1,
        marker=markers[0],
        color=colors[i],
        markerfacecolor=colors[i],
        linewidth=2,
        markersize=6,
        label=f"{key}{label_1}",
    )
    ax.plot(
        time_intervals,
        series2,
        marker=markers[1],
        color=colors[i],
        markerfacecolor=colors[i],
        linestyle='--',
        linewidth=2,
        markersize=6,
        label=f"{key}{label_2}",
    )
    ax.fill_between(
        time_intervals, series1 - 5, series1 + 5, color=colors[i], alpha=0.1
    )
    ax.fill_between(
        time_intervals, series2 - 2, series2 + 2, color=colors[i], alpha=0.1
    )
    ax.set_title(f"{key} Performance", fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel_1_value if i % 2 == 0 else ylabel_2_value, fontsize=12)
    ax.set_ylim(ylim_1_values if i % 2 == 0 else ylim_2_values)
    ax.set_xticks(xticks_values)
    ax.legend()
    ax.grid(True, linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_268.pdf", bbox_inches="tight")
