
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
quarters = np.array(['Q1', 'Q2', 'Q3', 'Q4', 'Q5', 'Q6', 'Q7', 'Q8'])
gdp_growth = np.clip(
    np.linspace(2, 4.5, len(quarters)) + np.random.normal(0, 0.3, len(quarters)),
    1,
    5,
)
unemployment_rate = np.clip(
    np.linspace(7, 3, len(quarters)) + np.random.normal(0, 0.5, len(quarters)),
    2,
    10,
)
national_avg_gdp = [3] * len(quarters)  # National Average constant GDP Growth Rate
national_avg_unemployment = [5] * len(quarters)  # National Average constant Unemployment Rate

# Axes Limits and Labels
xlabel_value = "Quarter"

ylabel_value_1 = "GDP Growth Rate (%)"
ylabel_value_2 = "Unemployment Rate (%)"
ylim_values_1 = [1, 5]
ylim_values_2 = [2, 10]
yticks_values_1 = np.arange(1, 6, 1)
yticks_values_2 = np.arange(2, 11, 1)

# Labels
label_1 = "GDP Growth Rate (%)"
label_2 = "Unemployment Rate (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(8, 6))

# GDP Growth Rate and Unemployment Rate plots
(gdp_line,) = ax1.plot(
    quarters,
    gdp_growth,
    "o-",
    color="#2E8B57",
    label=label_1,
    markersize=8,
    linewidth=2,
    mec="black",
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color="#2E8B57")
ax1.tick_params(
    axis="y", labelcolor="#2E8B57", direction="in", rotation=90, labelsize=12
)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

ax2 = ax1.twinx()
(unemployment_line,) = ax2.plot(
    quarters,
    unemployment_rate,
    "s-",
    color="#4B0082",
    label=label_2,
    markersize=8,
    linewidth=2,
    mec="black",
)
ax2.set_ylabel(ylabel_value_2, color="#4B0082", fontsize=14)
ax2.tick_params(
    axis="y", labelcolor="#4B0082", direction="in", rotation=90, labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# National Average constant scores
ax1.axhline(y=3, color="#2E8B57", linestyle=":", linewidth=2)
ax1.axhline(y=5, color="#4B0082", linestyle="--", linewidth=2)

# Custom legend for the plot
national_avg_gdp_legend = Line2D([0], [0], color="black", linestyle=":", linewidth=2, label="National Avg GDP")
national_avg_unemployment_legend = Line2D([0], [0], color="black", linestyle="--", linewidth=2, label="National Avg Unemployment")

# Add the legend to the plot
first_legend = ax1.legend(
    handles=[national_avg_gdp_legend, national_avg_unemployment_legend],
    loc="upper left",
    ncol=2,
    fontsize=14,
    edgecolor="black",
)
ax1.add_artist(first_legend)

# ===================
# Part 4: Saving Output
# ===================
# Add the second legend to the plot
plt.tight_layout()
plt.savefig("line_271.pdf", bbox_inches="tight")

