
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Age groups in decades (20s, 30s, 40s, 50s, 60s, 70s, 80s)
age_groups = np.array([20, 30, 40, 50, 60, 70, 80])

# Simulated response time and user satisfaction scores
response_time = np.clip(
    np.linspace(1.5, 3.0, len(age_groups)) + np.random.normal(0, 0.2, len(age_groups)),
    1.5,
    3.5,
)
user_satisfaction = np.clip(
    np.linspace(4.0, 2.5, len(age_groups)) + np.random.normal(0, 0.5, len(age_groups)),
    2.0,
    5.0,
)

# Axes Limits and Labels
xlabel_value = "Age Group"
ylabel_value_1 = "Response Time (Seconds)"
ylabel_value_2 = "User Satisfaction (Rating)"

# Labels
label_1 = "Response Time"
label_2 = "User Satisfaction"
label = "Average Response Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot Response Time
(response_time_line,) = ax.plot(
    age_groups,
    response_time,
    "o-",
    color="#1f77b4",
    label=label_1,
    markersize=8,
    linewidth=2,
)

ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value_1, fontsize=12)
ax.tick_params(axis="y", direction="in", labelsize=10)
ax.tick_params(axis="x", direction="in", labelsize=10)

# Plot User Satisfaction
(user_satisfaction_line,) = ax.plot(
    age_groups,
    user_satisfaction,
    "s--",
    color="#ff7f0e",
    label=label_2,
    markersize=8,
    linewidth=2,
)

# Add a horizontal line for average response time
avg_response_time = np.mean(response_time)
ax.axhline(y=avg_response_time, color="green", linestyle="-", linewidth=1.5, label=label)

# Highlight specific age groups with significant scores
highlight = [30, 50, 70]
for group in highlight:
    ax.plot(
        group, response_time[np.where(age_groups == group)], "ro"
    )  # Highlight Response Time
    ax.annotate(
        f"Age {group}s",
        (group, response_time[np.where(age_groups == group)]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Customize the plot with labels, title, and legend
ax.legend()

# Add a grid to the plot
ax.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_277.pdf", bbox_inches="tight")
