

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the plot
months = np.array(range(1, 13))
high_temps = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(months))) * 15
    + np.random.normal(0, 5, len(months))
    + 25,
    -10,
    40,
)
low_temps = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(months))) * 10
    + np.random.normal(0, 5, len(months))
    + 10,
    -10,
    40,
)
highlight = [1, 7, 12]

# Axes Limits and Labels
xlabel_value = "Month"
ylabel_value_1 = "Average High Temp (°C)"
ylabel_value_2 = "Average Low Temp (°C)"

# Labels
label_1 = "Low Temp"
label_2 = "Freezing Point"

label = "High Temp"

# Titles for the charts
title_1 = "Monthly Average High Temperatures"
title_2 = "Monthly Average Low Temperatures"

# Supertitle for the entire figure
supertitle = "Monthly Temperature Trends Over a Year"

# Additional labels for annotation
highlight_annotation = "Extreme Month"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 1x2 grid
fig, axs = plt.subplots(1, 2, figsize=(14, 6))

# Plot the High Temperatures data
(online_sales_line,) = axs[0].plot(
    months,
    high_temps,
    "o-",
    color="#1f77b4",
    label=label,
    markersize=8,
    linewidth=2,
)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value_1, fontsize=12)
axs[0].tick_params(axis="y", direction="in", labelsize=10)
axs[0].tick_params(axis="x", direction="in", labelsize=10)
axs[0].set_title(title_1)

# Plot the Low Temperatures data
(store_sales_line,) = axs[1].plot(
    months,
    low_temps,
    "s--",
    color="#2ca02c",
    label=label_1,
    markersize=8,
    linewidth=2,
)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_value_2, fontsize=12)
axs[1].tick_params(axis="y", direction="in", labelsize=10)
axs[1].tick_params(axis="x", direction="in", labelsize=10)
axs[1].set_title(title_2)

# Add a legend to the plot
threshold = 0
axs[0].axhline(y=threshold, color="red", linestyle="-", linewidth=1.5, label=label_2)
axs[1].axhline(y=threshold, color="red", linestyle="-", linewidth=1.5, label=label_2)

# Highlight the data points above the threshold
for ax in axs:
    for month in highlight:
        ax.plot(
            month,
            high_temps[np.where(months == month)], "ro"
        )  # Highlight High Temps
        ax.annotate(
            highlight_annotation,
            (month, high_temps[np.where(months == month)]),
            textcoords="offset points",
            xytext=(0, -20),
            ha="center",
        )

# Customize the plot with labels, title, and legend
axs[0].legend()
axs[1].legend()

# Add a grid to the plot
for ax in axs:
    ax.grid(True, linestyle="--", alpha=0.6)

# Add supertitle for the entire figure
plt.suptitle(supertitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("line_278.pdf", bbox_inches="tight")

