
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data (example values, the actual data should be extracted from the paper)
years = [2000, 2005, 2010, 2015, 2020]
stock_company_a = [100, 120, 140, 180, 200]
stock_company_b = [150, 130, 120, 110, 150]
stock_company_c = [80, 90, 110, 130, 170]
stock_company_d = [60, 70, 95, 105, 125]

# Labels and Plot Types
label_company_a = "Company A"
label_company_b = "Company B"
label_company_c = "Company C"
label_company_d = "Company D"

# Axes Limits and Labels
xlim_values = [2000, 2020]
ylim_values = [50, 200]
xlabel_value = "Year"
ylabel_value = "Stock Price (USD)"
xticks_values = np.arange(2000, 2021, 5)
yticks_values = np.arange(50, 201, 25)
xtickslabel_values = None  # Not specified in the code
ytickslabel_values = None  # Not specified in the code
title_value = "Stock Prices Over Time"
axhiline_value = None  # Not specified in the code
axvline_value = None  # Not specified in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years,
    stock_company_a,
    "-o",
    label=label_company_a,
    color="#4daf4a",
    clip_on=False,
    zorder=10,
    linewidth=2,
)
plt.plot(
    years,
    stock_company_b,
    "-^",
    label=label_company_b,
    color="#377eb8",
    clip_on=False,
    zorder=10,
    linewidth=2,
)
plt.plot(
    years,
    stock_company_c,
    "-s",
    label=label_company_c,
    color="#ff7f00",
    clip_on=False,
    zorder=10,
    linewidth=2,
)
plt.plot(
    years,
    stock_company_d,
    "-d",
    label=label_company_d,
    color="#e41a1c",
    clip_on=False,
    zorder=10,
    linewidth=2,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding grid, legend, and labels
plt.grid(True)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=4, frameon=False)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title_value)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout(rect=[0, 0, 1, 0.95])  # Adjusting layout to give space for the title
plt.savefig("line_71.pdf", bbox_inches="tight")

