
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
years = [1000, 1200, 1400, 1600, 1800, 2000]
ancient_greek = [30, 25, 20, 10, 5, 3]
medieval = [5, 20, 40, 45, 15, 5]
enlightenment = [2, 5, 10, 40, 60, 85]
modern = [1, 2, 5, 20, 50, 95]

# Labels and Plot Types
label_ancient_greek = "Ancient Greek"
label_medieval = "Medieval"
label_enlightenment = "Enlightenment"
label_modern = "Modern"

# Axes Limits and Labels
xlim_values = [1000, 2000]
ylim_values = [0, 100]
xlabel_value = "Year"
ylabel_value = "Influence Index"
xticks_values = np.arange(1000, 2100, 200)
yticks_values = np.arange(0, 101, 20)
title_value = "Influence of Philosophical Schools Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 7))  # Adjusting figure size for better readability
plt.plot(
    years,
    ancient_greek,
    linestyle='--',
    marker='o',
    label=label_ancient_greek,
    color="tomato",
    clip_on=False,
    zorder=10,
)
plt.plot(
    years,
    medieval,
    linestyle='-.',
    marker='^',
    label=label_medieval,
    color="royalblue",
    clip_on=False,
    zorder=10,
)
plt.plot(
    years,
    enlightenment,
    linestyle=':',
    marker='s',
    label=label_enlightenment,
    color="green",
    clip_on=False,
    zorder=10,
)
plt.plot(
    years,
    modern,
    linestyle='-',
    marker='x',
    label=label_modern,
    color="purple",
    clip_on=False,
    zorder=10,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding grid, legend, and labels
plt.grid(True)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=2, frameon=False)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title_value)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_73.pdf", bbox_inches="tight")
