
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
days = np.arange(1, 32, 7)  # 5 data points representing every 7th day in a month
city_A_temps = [5, 7, 12, 15, 20]  # City A temperatures in Celsius
city_B_temps = [10, 12, 14, 18, 22]  # City B temperatures in Celsius
city_C_temps = [0, 2, 6, 9, 14]  # City C temperatures in Celsius

# Simulating standard deviations for error
city_A_std = np.random.rand(5) * 2
city_B_std = np.random.rand(5) * 2
city_C_std = np.random.rand(5) * 2

# Labels
label_City_A = "City A"
label_City_B = "City B"
label_City_C = "City C"

# Axes Limits and Labels
xlabel_value = "Days"
ylabel_value = "Temperature (°C)"
yticks_values = np.arange(-5, 35, 5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines with error bands
plt.figure(figsize=(4, 3))

# City A
plt.plot(days, city_A_temps, "o-", color="#0077b6", label=label_City_A)
plt.fill_between(days, city_A_temps - city_A_std, city_A_temps + city_A_std, color="#0077b6", alpha=0.2)

# City B
plt.plot(days, city_B_temps, "s--", color="#90be6d", label=label_City_B)
plt.fill_between(days, city_B_temps - city_B_std, city_B_temps + city_B_std, color="#90be6d", alpha=0.2)

# City C
plt.plot(days, city_C_temps, "d-.", color="#f94144", label=label_City_C)
plt.fill_between(days, city_C_temps - city_C_std, city_C_temps + city_C_std, color="#f94144", alpha=0.2)

# x labels
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(days)
plt.yticks(yticks_values)
plt.title("Temperature Trends Over a Month")

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["left"].set_position(("outward", 10))  # move left y-axis outwards
ax.spines["bottom"].set_position(("outward", 10))  # move bottom x-axis outwards
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5)

# Legend
plt.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("line_76.pdf", bbox_inches="tight")
