

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
bus_line_1_ridership = [1200, 1500, 1800, 1600, 2000, 2100, 2200, 2100, 1900, 1950, 2000, 1750]
bus_line_1_avg = [1100, 1400, 1700, 1500, 1900, 2000, 2100, 2000, 1800, 1850, 1900, 1700]
bus_line_2_ridership = [1000, 1200, 1300, 1250, 1350, 1450, 1600, 1550, 1400, 1420, 1500, 1300]
bus_line_2_avg = [900, 1100, 1200, 1150, 1250, 1350, 1500, 1450, 1300, 1320, 1400, 1200]

# Axes Limits and Labels
xticks_values = range(len(months))
ylabel_value = "Ridership (in 1000s)"

# Labels
label_ridership = "Monthly Ridership"
label_avg = "Average Ridership"

# Titles
title_bus_line_1 = "Bus Line 1 Ridership"
title_bus_line_2 = "Bus Line 2 Ridership"

# Texts
text_bus_line_1 = "Peak Month"
text_bus_line_2 = "Ridership Growth"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Plotting for Bus Line 1
ax1.set_xticks(xticks_values)  # Setting categorical x-axis
ax1.plot(
    months,
    bus_line_1_ridership,
    marker="s",
    color="#FF5733",
    label=label_ridership,
    linewidth=3,
    markersize=9,
)
ax1.plot(
    months,
    bus_line_1_avg,
    marker="^",
    linestyle="--",
    color="#1F618D",
    label=label_avg,
    linewidth=3,
    markersize=9,
)
ax1.set_title(title_bus_line_1, fontsize=16)
ax1.set_ylabel(ylabel_value, fontsize=16)
ax1.legend(loc="lower left", fontsize=14)
ax1.set_xticklabels(months, fontsize=12)
ax1.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax1.annotate(
    text_bus_line_1,
    xy=(4, bus_line_1_ridership[4]),
    xytext=(4, bus_line_1_ridership[4] + 150),
    arrowprops=dict(color="green", shrink=0.05, width=1.5, headwidth=8),
)
ax1.text(
    4.5,
    bus_line_1_avg[4] - 150,
    f"{bus_line_1_ridership[4]}",
    ha="left",
    va="center",
    fontsize=12,
    color="black",
)

# Plotting for Bus Line 2
ax2.plot(
    months,
    bus_line_2_ridership,
    marker="o",
    color="#33FF57",
    label=label_ridership,
    linewidth=3,
    markersize=9,
)
ax2.plot(
    months,
    bus_line_2_avg,
    marker="x",
    linestyle="--",
    color="#8E44AD",
    label=label_avg,
    linewidth=3,
    markersize=9,
)
ax2.set_title(title_bus_line_2, fontsize=16)
ax2.legend(loc="lower left", fontsize=14)
ax2.set_xticklabels(months, fontsize=12)
ax2.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax2.annotate(
    text_bus_line_2,
    xy=(6, bus_line_2_ridership[6]),
    xytext=(6, bus_line_2_ridership[6] + 150),
    arrowprops=dict(color="green", shrink=0.05, width=1.5, headwidth=8),
)


# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and add common annotation for months
plt.tight_layout()
plt.savefig("line_80.pdf", bbox_inches="tight")

