
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data for Monthly Average Temperature over a Year (12 months)
months = np.arange(1, 13, 1)
temperature_city1 = np.random.normal(15, 5, 12)  # City 1 average temperatures
temperature_city2 = np.random.normal(20, 5, 12)  # City 2 average temperatures
temperature_city3 = np.random.normal(10, 5, 12)  # City 3 average temperatures

# Labels and Plot Types
label_city1 = "City 1 Average Temp"
label_city2 = "City 2 Average Temp"
label_city3 = "City 3 Average Temp"

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Temperature (°C)"
xlim_values = [0, 13]
ylim_values = [-5, 35]
xticks_values = np.arange(1, 13, 1)
yticks_values = np.arange(-5, 36, 5)
title="Monthly Average Temperature Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))
plt.plot(
    months, temperature_city1, "o-", label=label_city1, color="#2E8B57", linewidth=2, markersize=5
)
plt.plot(
    months, temperature_city2, "s-", label=label_city2, color="#1E90FF", linewidth=2, markersize=5
)
plt.plot(
    months, temperature_city3, "D-", label=label_city3, color="#FF6347", linewidth=2, markersize=5
)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18, pad=20)

# Adjusting x and y axis limits
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Setting x and y ticks
plt.xticks(xticks_values)  # X-axis from 1 to 12 with a step of 1
plt.yticks(yticks_values)  # Y-axis from -5 to 35 with a step of 5

# Adding legend outside the plot area
plt.legend(loc="upper left", bbox_to_anchor=(1, 1), fancybox=True, shadow=True)

# Adding semi-transparent grid
plt.grid(True, which="both", linewidth=0.5, alpha=0.3)  # Semi-transparent grid

# Removing top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_83.pdf", bbox_inches="tight")
