
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data
age_groups = [10, 20, 30, 40, 50, 60, 70, 80, 90, 100]
church_attendance = [1, 2, 2, 4, 4, 4, 3, 2, 2, 1]
prayer_hours = [1, 2, 3, 4, 5, 4, 3, 3, 2, 2]
volunteer_hours = [0, 1, 1, 2, 2, 3, 2, 1, 1, 1]

# Labels and Plot Types
label_church = "Church Attendance"
label_prayer = "Prayer Hours"
label_volunteer = "Volunteer Hours"

# Axes Limits and Labels
xlabel_value = "Age Group"
ylabel_value = "Hours per Week"
xlim_values = [5, 105]
ylim_values = [0, 6]
xticks_values = range(10, 101, 10)
yticks_values = range(0, 7, 1)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 5))  # Adjusting figure size as per the given dimensions
plt.plot(
    age_groups, church_attendance, "s-", label=label_church, color="#ff0000", linewidth=1.5
)
plt.plot(
    age_groups, prayer_hours, "o-", label=label_prayer, color="#00ff00", linewidth=1.5
)
plt.plot(
    age_groups, volunteer_hours, "x-", label=label_volunteer, color="#0000ff", linewidth=1.5
)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Adjusting x and y axis limits to add some space before the start and after the end
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Setting x and y ticks
plt.xticks(xticks_values)
plt.yticks(yticks_values)

# Adding legend outside the plot area
plt.legend(loc="upper right", fancybox=True, shadow=False)

# Adding semi-transparent grid
plt.grid(True, which="both", linewidth=0.5, alpha=0.2)  # Semi-transparent grid

# Removing top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_84.pdf", bbox_inches="tight")
