
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data (Religion domain)
years = list(range(2000, 2011))
percent_christianity = [55, 54, 53, 52, 52, 51, 51, 50, 50, 50, 49]
percent_islam = [25, 26, 27, 27, 28, 28, 29, 29, 29, 30, 30]
percent_hinduism = [20, 20, 20, 21, 20, 21, 20, 21, 21, 20, 21]

# Labels and Plot Types
label_christianity = "Christianity"
label_islam = "Islam"
label_hinduism = "Hinduism"

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value = "Percentage (%)"
xlim_values = [1999, 2011]
ylim_values = [15, 60]
xticks_values = range(2000, 2011, 1)
yticks_values = np.arange(15, 61, 5)
title = "Religious Distribution Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 5))  # Adjusting figure size for better readability
plt.plot(
    years, percent_christianity, "o-", label=label_christianity, color="#4CAF50", linewidth=2, markersize=6
)
plt.plot(
    years,
    percent_islam,
    "s-",
    label=label_islam,
    color="#FFB74D",
    linewidth=2,
    markersize=6
)
plt.plot(
    years,
    percent_hinduism,
    "d-",
    label=label_hinduism,
    color="#8D6E63",
    linewidth=2,
    markersize=6
)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18)

# Adjusting x and y axis limits to add some space before the start and after the end
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Setting x and y ticks
plt.xticks(xticks_values, fontsize=12)  # X-axis from 2000 to 2010 with a step of 1
plt.yticks(yticks_values, fontsize=12)  # Y-axis from 15 to 60 with a step of 5

# Adding legend outside the plot area
plt.legend(loc="upper center",ncol=3, fancybox=True, shadow=False, fontsize=12)

# Adding semi-transparent grid for better readability
plt.grid(True, which="major", linewidth=0.5, alpha=0.5)  # Semi-transparent grid

# Removing top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_85.pdf", bbox_inches="tight")
